/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SchlageDeviceMetadata {
    private final String deviceId;
    private final String deviceName;
    private final int accessCodeLength;
    private final Optional<String> model;
    private final Optional<String> locationId;

    private SchlageDeviceMetadata(String deviceId, String deviceName, int accessCodeLength, Optional<String> model, Optional<String> locationId) {
        this.deviceId = deviceId;
        this.deviceName = deviceName;
        this.accessCodeLength = accessCodeLength;
        this.model = model;
        this.locationId = locationId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="device_name")
    public String getDeviceName() {
        return this.deviceName;
    }

    @JsonProperty(value="access_code_length")
    public int getAccessCodeLength() {
        return this.accessCodeLength;
    }

    @JsonProperty(value="model")
    public Optional<String> getModel() {
        return this.model;
    }

    @JsonProperty(value="location_id")
    public Optional<String> getLocationId() {
        return this.locationId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SchlageDeviceMetadata && this.equalTo((SchlageDeviceMetadata)other);
    }

    private boolean equalTo(SchlageDeviceMetadata other) {
        return this.deviceId.equals(other.deviceId) && this.deviceName.equals(other.deviceName) && this.accessCodeLength == other.accessCodeLength && this.model.equals(other.model) && this.locationId.equals(other.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.deviceName, this.accessCodeLength, this.model, this.locationId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    DeviceNameStage,
    AccessCodeLengthStage,
    _FinalStage {
        private String deviceId;
        private String deviceName;
        private int accessCodeLength;
        private Optional<String> locationId = Optional.empty();
        private Optional<String> model = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(SchlageDeviceMetadata other) {
            this.deviceId(other.getDeviceId());
            this.deviceName(other.getDeviceName());
            this.accessCodeLength(other.getAccessCodeLength());
            this.model(other.getModel());
            this.locationId(other.getLocationId());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public DeviceNameStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="device_name")
        public AccessCodeLengthStage deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        @Override
        @JsonSetter(value="access_code_length")
        public _FinalStage accessCodeLength(int accessCodeLength) {
            this.accessCodeLength = accessCodeLength;
            return this;
        }

        @Override
        public _FinalStage locationId(String locationId) {
            this.locationId = Optional.of(locationId);
            return this;
        }

        @Override
        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public _FinalStage locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        @Override
        public _FinalStage model(String model) {
            this.model = Optional.of(model);
            return this;
        }

        @Override
        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public _FinalStage model(Optional<String> model) {
            this.model = model;
            return this;
        }

        @Override
        public SchlageDeviceMetadata build() {
            return new SchlageDeviceMetadata(this.deviceId, this.deviceName, this.accessCodeLength, this.model, this.locationId);
        }
    }

    public static interface _FinalStage {
        public SchlageDeviceMetadata build();

        public _FinalStage model(Optional<String> var1);

        public _FinalStage model(String var1);

        public _FinalStage locationId(Optional<String> var1);

        public _FinalStage locationId(String var1);
    }

    public static interface AccessCodeLengthStage {
        public _FinalStage accessCodeLength(int var1);
    }

    public static interface DeviceNameStage {
        public AccessCodeLengthStage deviceName(String var1);
    }

    public static interface DeviceIdStage {
        public DeviceNameStage deviceId(String var1);

        public Builder from(SchlageDeviceMetadata var1);
    }
}

