/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.ServiceHealthStatus;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ServiceHealth {
    private final String service;
    private final ServiceHealthStatus status;
    private final String description;

    private ServiceHealth(String service, ServiceHealthStatus status, String description) {
        this.service = service;
        this.status = status;
        this.description = description;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="status")
    public ServiceHealthStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ServiceHealth && this.equalTo((ServiceHealth)other);
    }

    private boolean equalTo(ServiceHealth other) {
        return this.service.equals(other.service) && this.status.equals((Object)other.status) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.service, this.status, this.description});
    }

    public String toString() {
        return "ServiceHealth{service: " + this.service + ", status: " + this.status + ", description: " + this.description + "}";
    }

    public static ServiceStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ServiceStage,
    StatusStage,
    DescriptionStage,
    _FinalStage {
        private String service;
        private ServiceHealthStatus status;
        private String description;

        private Builder() {
        }

        @Override
        public Builder from(ServiceHealth other) {
            this.service(other.getService());
            this.status(other.getStatus());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="service")
        public StatusStage service(String service) {
            this.service = service;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public DescriptionStage status(ServiceHealthStatus status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public _FinalStage description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ServiceHealth build() {
            return new ServiceHealth(this.service, this.status, this.description);
        }
    }

    public static interface _FinalStage {
        public ServiceHealth build();
    }

    public static interface DescriptionStage {
        public _FinalStage description(String var1);
    }

    public static interface StatusStage {
        public DescriptionStage status(ServiceHealthStatus var1);
    }

    public static interface ServiceStage {
        public StatusStage service(String var1);

        public Builder from(ServiceHealth var1);
    }
}

