/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.devices.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.DevicesUpdateRequestLocation;
import com.seam.api.types.DevicesUpdateRequestProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DevicesUpdateRequest {
    private final String deviceId;
    private final Optional<DevicesUpdateRequestProperties> properties;
    private final Optional<String> name;
    private final Optional<DevicesUpdateRequestLocation> location;
    private final Optional<Boolean> isManaged;
    private final Map<String, Object> additionalProperties;

    private DevicesUpdateRequest(String deviceId, Optional<DevicesUpdateRequestProperties> properties, Optional<String> name, Optional<DevicesUpdateRequestLocation> location, Optional<Boolean> isManaged, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.properties = properties;
        this.name = name;
        this.location = location;
        this.isManaged = isManaged;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="properties")
    public Optional<DevicesUpdateRequestProperties> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="location")
    public Optional<DevicesUpdateRequestLocation> getLocation() {
        return this.location;
    }

    @JsonProperty(value="is_managed")
    public Optional<Boolean> getIsManaged() {
        return this.isManaged;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DevicesUpdateRequest && this.equalTo((DevicesUpdateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DevicesUpdateRequest other) {
        return this.deviceId.equals(other.deviceId) && this.properties.equals(other.properties) && this.name.equals(other.name) && this.location.equals(other.location) && this.isManaged.equals(other.isManaged);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.properties, this.name, this.location, this.isManaged);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    _FinalStage {
        private String deviceId;
        private Optional<Boolean> isManaged = Optional.empty();
        private Optional<DevicesUpdateRequestLocation> location = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<DevicesUpdateRequestProperties> properties = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DevicesUpdateRequest other) {
            this.deviceId(other.getDeviceId());
            this.properties(other.getProperties());
            this.name(other.getName());
            this.location(other.getLocation());
            this.isManaged(other.getIsManaged());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage isManaged(Boolean isManaged) {
            this.isManaged = Optional.of(isManaged);
            return this;
        }

        @Override
        @JsonSetter(value="is_managed", nulls=Nulls.SKIP)
        public _FinalStage isManaged(Optional<Boolean> isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        public _FinalStage location(DevicesUpdateRequestLocation location) {
            this.location = Optional.of(location);
            return this;
        }

        @Override
        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public _FinalStage location(Optional<DevicesUpdateRequestLocation> location) {
            this.location = location;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage properties(DevicesUpdateRequestProperties properties) {
            this.properties = Optional.of(properties);
            return this;
        }

        @Override
        @JsonSetter(value="properties", nulls=Nulls.SKIP)
        public _FinalStage properties(Optional<DevicesUpdateRequestProperties> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public DevicesUpdateRequest build() {
            return new DevicesUpdateRequest(this.deviceId, this.properties, this.name, this.location, this.isManaged, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DevicesUpdateRequest build();

        public _FinalStage properties(Optional<DevicesUpdateRequestProperties> var1);

        public _FinalStage properties(DevicesUpdateRequestProperties var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage location(Optional<DevicesUpdateRequestLocation> var1);

        public _FinalStage location(DevicesUpdateRequestLocation var1);

        public _FinalStage isManaged(Optional<Boolean> var1);

        public _FinalStage isManaged(Boolean var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(String var1);

        public Builder from(DevicesUpdateRequest var1);
    }
}

