/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.unmanaged.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UnmanagedConvertToManagedRequest {
    private final String accessCodeId;
    private final Optional<Boolean> force;
    private final Optional<Boolean> sync;

    private UnmanagedConvertToManagedRequest(String accessCodeId, Optional<Boolean> force, Optional<Boolean> sync) {
        this.accessCodeId = accessCodeId;
        this.force = force;
        this.sync = sync;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="force")
    public Optional<Boolean> getForce() {
        return this.force;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedConvertToManagedRequest && this.equalTo((UnmanagedConvertToManagedRequest)other);
    }

    private boolean equalTo(UnmanagedConvertToManagedRequest other) {
        return this.accessCodeId.equals(other.accessCodeId) && this.force.equals(other.force) && this.sync.equals(other.sync);
    }

    public int hashCode() {
        return Objects.hash(this.accessCodeId, this.force, this.sync);
    }

    public String toString() {
        return "UnmanagedConvertToManagedRequest{accessCodeId: " + this.accessCodeId + ", force: " + this.force + ", sync: " + this.sync + "}";
    }

    public static AccessCodeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessCodeIdStage,
    _FinalStage {
        private String accessCodeId;
        private Optional<Boolean> sync = Optional.empty();
        private Optional<Boolean> force = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(UnmanagedConvertToManagedRequest other) {
            this.accessCodeId(other.getAccessCodeId());
            this.force(other.getForce());
            this.sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public _FinalStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public _FinalStage force(Boolean force) {
            this.force = Optional.of(force);
            return this;
        }

        @Override
        @JsonSetter(value="force", nulls=Nulls.SKIP)
        public _FinalStage force(Optional<Boolean> force) {
            this.force = force;
            return this;
        }

        @Override
        public UnmanagedConvertToManagedRequest build() {
            return new UnmanagedConvertToManagedRequest(this.accessCodeId, this.force, this.sync);
        }
    }

    public static interface _FinalStage {
        public UnmanagedConvertToManagedRequest build();

        public _FinalStage force(Optional<Boolean> var1);

        public _FinalStage force(Boolean var1);

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);
    }

    public static interface AccessCodeIdStage {
        public _FinalStage accessCodeId(String var1);

        public Builder from(UnmanagedConvertToManagedRequest var1);
    }
}

