/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.devices.unmanaged.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UnmanagedUpdateRequest {
    private final String deviceId;
    private final String isManaged;

    private UnmanagedUpdateRequest(String deviceId, String isManaged) {
        this.deviceId = deviceId;
        this.isManaged = isManaged;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="is_managed")
    public String getIsManaged() {
        return this.isManaged;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedUpdateRequest && this.equalTo((UnmanagedUpdateRequest)other);
    }

    private boolean equalTo(UnmanagedUpdateRequest other) {
        return this.deviceId.equals(other.deviceId) && this.isManaged.equals(other.isManaged);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.isManaged);
    }

    public String toString() {
        return "UnmanagedUpdateRequest{deviceId: " + this.deviceId + ", isManaged: " + this.isManaged + "}";
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    IsManagedStage,
    _FinalStage {
        private String deviceId;
        private String isManaged;

        private Builder() {
        }

        @Override
        public Builder from(UnmanagedUpdateRequest other) {
            this.deviceId(other.getDeviceId());
            this.isManaged(other.getIsManaged());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public IsManagedStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="is_managed")
        public _FinalStage isManaged(String isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        public UnmanagedUpdateRequest build() {
            return new UnmanagedUpdateRequest(this.deviceId, this.isManaged);
        }
    }

    public static interface _FinalStage {
        public UnmanagedUpdateRequest build();
    }

    public static interface IsManagedStage {
        public _FinalStage isManaged(String var1);
    }

    public static interface DeviceIdStage {
        public IsManagedStage deviceId(String var1);

        public Builder from(UnmanagedUpdateRequest var1);
    }
}

