/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.AccessCodesUpdateRequestType;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccessCodesUpdateRequest {
    private final Optional<String> name;
    private final Optional<String> startsAt;
    private final Optional<String> endsAt;
    private final Optional<String> code;
    private final Optional<Boolean> sync;
    private final Optional<Boolean> attemptForOfflineDevice;
    private final Optional<Boolean> preferNativeScheduling;
    private final Optional<Boolean> useBackupAccessCodePool;
    private final String accessCodeId;
    private final Optional<String> deviceId;
    private final Optional<AccessCodesUpdateRequestType> type;

    private AccessCodesUpdateRequest(Optional<String> name, Optional<String> startsAt, Optional<String> endsAt, Optional<String> code, Optional<Boolean> sync, Optional<Boolean> attemptForOfflineDevice, Optional<Boolean> preferNativeScheduling, Optional<Boolean> useBackupAccessCodePool, String accessCodeId, Optional<String> deviceId, Optional<AccessCodesUpdateRequestType> type) {
        this.name = name;
        this.startsAt = startsAt;
        this.endsAt = endsAt;
        this.code = code;
        this.sync = sync;
        this.attemptForOfflineDevice = attemptForOfflineDevice;
        this.preferNativeScheduling = preferNativeScheduling;
        this.useBackupAccessCodePool = useBackupAccessCodePool;
        this.accessCodeId = accessCodeId;
        this.deviceId = deviceId;
        this.type = type;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="starts_at")
    public Optional<String> getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="ends_at")
    public Optional<String> getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    @JsonProperty(value="attempt_for_offline_device")
    public Optional<Boolean> getAttemptForOfflineDevice() {
        return this.attemptForOfflineDevice;
    }

    @JsonProperty(value="prefer_native_scheduling")
    public Optional<Boolean> getPreferNativeScheduling() {
        return this.preferNativeScheduling;
    }

    @JsonProperty(value="use_backup_access_code_pool")
    public Optional<Boolean> getUseBackupAccessCodePool() {
        return this.useBackupAccessCodePool;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="device_id")
    public Optional<String> getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="type")
    public Optional<AccessCodesUpdateRequestType> getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCodesUpdateRequest && this.equalTo((AccessCodesUpdateRequest)other);
    }

    private boolean equalTo(AccessCodesUpdateRequest other) {
        return this.name.equals(other.name) && this.startsAt.equals(other.startsAt) && this.endsAt.equals(other.endsAt) && this.code.equals(other.code) && this.sync.equals(other.sync) && this.attemptForOfflineDevice.equals(other.attemptForOfflineDevice) && this.preferNativeScheduling.equals(other.preferNativeScheduling) && this.useBackupAccessCodePool.equals(other.useBackupAccessCodePool) && this.accessCodeId.equals(other.accessCodeId) && this.deviceId.equals(other.deviceId) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.startsAt, this.endsAt, this.code, this.sync, this.attemptForOfflineDevice, this.preferNativeScheduling, this.useBackupAccessCodePool, this.accessCodeId, this.deviceId, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccessCodeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessCodeIdStage,
    _FinalStage {
        private String accessCodeId;
        private Optional<AccessCodesUpdateRequestType> type = Optional.empty();
        private Optional<String> deviceId = Optional.empty();
        private Optional<Boolean> useBackupAccessCodePool = Optional.empty();
        private Optional<Boolean> preferNativeScheduling = Optional.empty();
        private Optional<Boolean> attemptForOfflineDevice = Optional.empty();
        private Optional<Boolean> sync = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> endsAt = Optional.empty();
        private Optional<String> startsAt = Optional.empty();
        private Optional<String> name = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(AccessCodesUpdateRequest other) {
            this.name(other.getName());
            this.startsAt(other.getStartsAt());
            this.endsAt(other.getEndsAt());
            this.code(other.getCode());
            this.sync(other.getSync());
            this.attemptForOfflineDevice(other.getAttemptForOfflineDevice());
            this.preferNativeScheduling(other.getPreferNativeScheduling());
            this.useBackupAccessCodePool(other.getUseBackupAccessCodePool());
            this.accessCodeId(other.getAccessCodeId());
            this.deviceId(other.getDeviceId());
            this.type(other.getType());
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public _FinalStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        public _FinalStage type(AccessCodesUpdateRequestType type) {
            this.type = Optional.of(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<AccessCodesUpdateRequestType> type) {
            this.type = type;
            return this;
        }

        @Override
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = Optional.of(deviceId);
            return this;
        }

        @Override
        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public _FinalStage deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage useBackupAccessCodePool(Boolean useBackupAccessCodePool) {
            this.useBackupAccessCodePool = Optional.of(useBackupAccessCodePool);
            return this;
        }

        @Override
        @JsonSetter(value="use_backup_access_code_pool", nulls=Nulls.SKIP)
        public _FinalStage useBackupAccessCodePool(Optional<Boolean> useBackupAccessCodePool) {
            this.useBackupAccessCodePool = useBackupAccessCodePool;
            return this;
        }

        @Override
        public _FinalStage preferNativeScheduling(Boolean preferNativeScheduling) {
            this.preferNativeScheduling = Optional.of(preferNativeScheduling);
            return this;
        }

        @Override
        @JsonSetter(value="prefer_native_scheduling", nulls=Nulls.SKIP)
        public _FinalStage preferNativeScheduling(Optional<Boolean> preferNativeScheduling) {
            this.preferNativeScheduling = preferNativeScheduling;
            return this;
        }

        @Override
        public _FinalStage attemptForOfflineDevice(Boolean attemptForOfflineDevice) {
            this.attemptForOfflineDevice = Optional.of(attemptForOfflineDevice);
            return this;
        }

        @Override
        @JsonSetter(value="attempt_for_offline_device", nulls=Nulls.SKIP)
        public _FinalStage attemptForOfflineDevice(Optional<Boolean> attemptForOfflineDevice) {
            this.attemptForOfflineDevice = attemptForOfflineDevice;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public _FinalStage code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        @Override
        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public _FinalStage code(Optional<String> code) {
            this.code = code;
            return this;
        }

        @Override
        public _FinalStage endsAt(String endsAt) {
            this.endsAt = Optional.of(endsAt);
            return this;
        }

        @Override
        @JsonSetter(value="ends_at", nulls=Nulls.SKIP)
        public _FinalStage endsAt(Optional<String> endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        @Override
        public _FinalStage startsAt(String startsAt) {
            this.startsAt = Optional.of(startsAt);
            return this;
        }

        @Override
        @JsonSetter(value="starts_at", nulls=Nulls.SKIP)
        public _FinalStage startsAt(Optional<String> startsAt) {
            this.startsAt = startsAt;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public AccessCodesUpdateRequest build() {
            return new AccessCodesUpdateRequest(this.name, this.startsAt, this.endsAt, this.code, this.sync, this.attemptForOfflineDevice, this.preferNativeScheduling, this.useBackupAccessCodePool, this.accessCodeId, this.deviceId, this.type);
        }
    }

    public static interface _FinalStage {
        public AccessCodesUpdateRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage startsAt(Optional<String> var1);

        public _FinalStage startsAt(String var1);

        public _FinalStage endsAt(Optional<String> var1);

        public _FinalStage endsAt(String var1);

        public _FinalStage code(Optional<String> var1);

        public _FinalStage code(String var1);

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);

        public _FinalStage attemptForOfflineDevice(Optional<Boolean> var1);

        public _FinalStage attemptForOfflineDevice(Boolean var1);

        public _FinalStage preferNativeScheduling(Optional<Boolean> var1);

        public _FinalStage preferNativeScheduling(Boolean var1);

        public _FinalStage useBackupAccessCodePool(Optional<Boolean> var1);

        public _FinalStage useBackupAccessCodePool(Boolean var1);

        public _FinalStage deviceId(Optional<String> var1);

        public _FinalStage deviceId(String var1);

        public _FinalStage type(Optional<AccessCodesUpdateRequestType> var1);

        public _FinalStage type(AccessCodesUpdateRequestType var1);
    }

    public static interface AccessCodeIdStage {
        public _FinalStage accessCodeId(String var1);

        public Builder from(AccessCodesUpdateRequest var1);
    }
}

