/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.ConnectedAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ConnectedAccountsListResponse {
    private final List<ConnectedAccount> connectedAccounts;
    private final boolean ok;

    private ConnectedAccountsListResponse(List<ConnectedAccount> connectedAccounts, boolean ok) {
        this.connectedAccounts = connectedAccounts;
        this.ok = ok;
    }

    @JsonProperty(value="connected_accounts")
    public List<ConnectedAccount> getConnectedAccounts() {
        return this.connectedAccounts;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConnectedAccountsListResponse && this.equalTo((ConnectedAccountsListResponse)other);
    }

    private boolean equalTo(ConnectedAccountsListResponse other) {
        return this.connectedAccounts.equals(other.connectedAccounts) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.connectedAccounts, this.ok);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<ConnectedAccount> connectedAccounts = new ArrayList<ConnectedAccount>();

        private Builder() {
        }

        @Override
        public Builder from(ConnectedAccountsListResponse other) {
            this.connectedAccounts(other.getConnectedAccounts());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllConnectedAccounts(List<ConnectedAccount> connectedAccounts) {
            this.connectedAccounts.addAll(connectedAccounts);
            return this;
        }

        @Override
        public _FinalStage addConnectedAccounts(ConnectedAccount connectedAccounts) {
            this.connectedAccounts.add(connectedAccounts);
            return this;
        }

        @Override
        @JsonSetter(value="connected_accounts", nulls=Nulls.SKIP)
        public _FinalStage connectedAccounts(List<ConnectedAccount> connectedAccounts) {
            this.connectedAccounts.clear();
            this.connectedAccounts.addAll(connectedAccounts);
            return this;
        }

        @Override
        public ConnectedAccountsListResponse build() {
            return new ConnectedAccountsListResponse(this.connectedAccounts, this.ok);
        }
    }

    public static interface _FinalStage {
        public ConnectedAccountsListResponse build();

        public _FinalStage connectedAccounts(List<ConnectedAccount> var1);

        public _FinalStage addConnectedAccounts(ConnectedAccount var1);

        public _FinalStage addAllConnectedAccounts(List<ConnectedAccount> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(ConnectedAccountsListResponse var1);
    }
}

