/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.Webhook;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WebhooksListResponse {
    private final List<Webhook> webhooks;
    private final boolean ok;

    private WebhooksListResponse(List<Webhook> webhooks, boolean ok) {
        this.webhooks = webhooks;
        this.ok = ok;
    }

    @JsonProperty(value="webhooks")
    public List<Webhook> getWebhooks() {
        return this.webhooks;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhooksListResponse && this.equalTo((WebhooksListResponse)other);
    }

    private boolean equalTo(WebhooksListResponse other) {
        return this.webhooks.equals(other.webhooks) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.webhooks, this.ok);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<Webhook> webhooks = new ArrayList<Webhook>();

        private Builder() {
        }

        @Override
        public Builder from(WebhooksListResponse other) {
            this.webhooks(other.getWebhooks());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllWebhooks(List<Webhook> webhooks) {
            this.webhooks.addAll(webhooks);
            return this;
        }

        @Override
        public _FinalStage addWebhooks(Webhook webhooks) {
            this.webhooks.add(webhooks);
            return this;
        }

        @Override
        @JsonSetter(value="webhooks", nulls=Nulls.SKIP)
        public _FinalStage webhooks(List<Webhook> webhooks) {
            this.webhooks.clear();
            this.webhooks.addAll(webhooks);
            return this;
        }

        @Override
        public WebhooksListResponse build() {
            return new WebhooksListResponse(this.webhooks, this.ok);
        }
    }

    public static interface _FinalStage {
        public WebhooksListResponse build();

        public _FinalStage webhooks(List<Webhook> var1);

        public _FinalStage addWebhooks(Webhook var1);

        public _FinalStage addAllWebhooks(List<Webhook> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(WebhooksListResponse var1);
    }
}

