/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.resources.accesscodes.simulate.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = SimulateCreateUnmanagedAccessCodeRequest.Builder.class)
public final class SimulateCreateUnmanagedAccessCodeRequest {
    private final String deviceId;

    private final String name;

    private final String code;

    private final Map<String, Object> additionalProperties;

    private SimulateCreateUnmanagedAccessCodeRequest(
            String deviceId, String name, String code, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.name = name;
        this.code = code;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("device_id")
    public String getDeviceId() {
        return deviceId;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SimulateCreateUnmanagedAccessCodeRequest
                && equalTo((SimulateCreateUnmanagedAccessCodeRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SimulateCreateUnmanagedAccessCodeRequest other) {
        return deviceId.equals(other.deviceId) && name.equals(other.name) && code.equals(other.code);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deviceId, this.name, this.code);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    public interface DeviceIdStage {
        NameStage deviceId(String deviceId);

        Builder from(SimulateCreateUnmanagedAccessCodeRequest other);
    }

    public interface NameStage {
        CodeStage name(String name);
    }

    public interface CodeStage {
        _FinalStage code(String code);
    }

    public interface _FinalStage {
        SimulateCreateUnmanagedAccessCodeRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DeviceIdStage, NameStage, CodeStage, _FinalStage {
        private String deviceId;

        private String name;

        private String code;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @Override
        public Builder from(SimulateCreateUnmanagedAccessCodeRequest other) {
            deviceId(other.getDeviceId());
            name(other.getName());
            code(other.getCode());
            return this;
        }

        @Override
        @JsonSetter("device_id")
        public NameStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter("name")
        public CodeStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter("code")
        public _FinalStage code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public SimulateCreateUnmanagedAccessCodeRequest build() {
            return new SimulateCreateUnmanagedAccessCodeRequest(deviceId, name, code, additionalProperties);
        }
    }
}
