/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.resources.thermostats.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.FanModeSetting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ThermostatsSetFanModeRequest.Builder.class)
public final class ThermostatsSetFanModeRequest {
    private final String deviceId;

    private final Optional<FanModeSetting> fanMode;

    private final Optional<FanModeSetting> fanModeSetting;

    private final Optional<Boolean> sync;

    private final Map<String, Object> additionalProperties;

    private ThermostatsSetFanModeRequest(
            String deviceId,
            Optional<FanModeSetting> fanMode,
            Optional<FanModeSetting> fanModeSetting,
            Optional<Boolean> sync,
            Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.fanMode = fanMode;
        this.fanModeSetting = fanModeSetting;
        this.sync = sync;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("device_id")
    public String getDeviceId() {
        return deviceId;
    }

    @JsonProperty("fan_mode")
    public Optional<FanModeSetting> getFanMode() {
        return fanMode;
    }

    @JsonProperty("fan_mode_setting")
    public Optional<FanModeSetting> getFanModeSetting() {
        return fanModeSetting;
    }

    @JsonProperty("sync")
    public Optional<Boolean> getSync() {
        return sync;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ThermostatsSetFanModeRequest && equalTo((ThermostatsSetFanModeRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ThermostatsSetFanModeRequest other) {
        return deviceId.equals(other.deviceId)
                && fanMode.equals(other.fanMode)
                && fanModeSetting.equals(other.fanModeSetting)
                && sync.equals(other.sync);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.deviceId, this.fanMode, this.fanModeSetting, this.sync);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    public interface DeviceIdStage {
        _FinalStage deviceId(String deviceId);

        Builder from(ThermostatsSetFanModeRequest other);
    }

    public interface _FinalStage {
        ThermostatsSetFanModeRequest build();

        _FinalStage fanMode(Optional<FanModeSetting> fanMode);

        _FinalStage fanMode(FanModeSetting fanMode);

        _FinalStage fanModeSetting(Optional<FanModeSetting> fanModeSetting);

        _FinalStage fanModeSetting(FanModeSetting fanModeSetting);

        _FinalStage sync(Optional<Boolean> sync);

        _FinalStage sync(Boolean sync);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DeviceIdStage, _FinalStage {
        private String deviceId;

        private Optional<Boolean> sync = Optional.empty();

        private Optional<FanModeSetting> fanModeSetting = Optional.empty();

        private Optional<FanModeSetting> fanMode = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @Override
        public Builder from(ThermostatsSetFanModeRequest other) {
            deviceId(other.getDeviceId());
            fanMode(other.getFanMode());
            fanModeSetting(other.getFanModeSetting());
            sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter("device_id")
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value = "sync", nulls = Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public _FinalStage fanModeSetting(FanModeSetting fanModeSetting) {
            this.fanModeSetting = Optional.of(fanModeSetting);
            return this;
        }

        @Override
        @JsonSetter(value = "fan_mode_setting", nulls = Nulls.SKIP)
        public _FinalStage fanModeSetting(Optional<FanModeSetting> fanModeSetting) {
            this.fanModeSetting = fanModeSetting;
            return this;
        }

        @Override
        public _FinalStage fanMode(FanModeSetting fanMode) {
            this.fanMode = Optional.of(fanMode);
            return this;
        }

        @Override
        @JsonSetter(value = "fan_mode", nulls = Nulls.SKIP)
        public _FinalStage fanMode(Optional<FanModeSetting> fanMode) {
            this.fanMode = fanMode;
            return this;
        }

        @Override
        public ThermostatsSetFanModeRequest build() {
            return new ThermostatsSetFanModeRequest(deviceId, fanMode, fanModeSetting, sync, additionalProperties);
        }
    }
}
