/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = DeviceProperties.Builder.class)
public final class DeviceProperties {
    private final boolean online;

    private final String name;

    private final DevicePropertiesModel model;

    private final Optional<AugustDeviceMetadata> augustMetadata;

    private final Optional<SchlageDeviceMetadata> schlageMetadata;

    private final Object smartthingsMetadata;

    private final Optional<CurrentClimateSetting> currentClimateSetting;

    private final Map<String, Object> additionalProperties;

    private DeviceProperties(
            boolean online,
            String name,
            DevicePropertiesModel model,
            Optional<AugustDeviceMetadata> augustMetadata,
            Optional<SchlageDeviceMetadata> schlageMetadata,
            Object smartthingsMetadata,
            Optional<CurrentClimateSetting> currentClimateSetting,
            Map<String, Object> additionalProperties) {
        this.online = online;
        this.name = name;
        this.model = model;
        this.augustMetadata = augustMetadata;
        this.schlageMetadata = schlageMetadata;
        this.smartthingsMetadata = smartthingsMetadata;
        this.currentClimateSetting = currentClimateSetting;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("online")
    public boolean getOnline() {
        return online;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("model")
    public DevicePropertiesModel getModel() {
        return model;
    }

    @JsonProperty("august_metadata")
    public Optional<AugustDeviceMetadata> getAugustMetadata() {
        return augustMetadata;
    }

    @JsonProperty("schlage_metadata")
    public Optional<SchlageDeviceMetadata> getSchlageMetadata() {
        return schlageMetadata;
    }

    @JsonProperty("smartthings_metadata")
    public Object getSmartthingsMetadata() {
        return smartthingsMetadata;
    }

    @JsonProperty("current_climate_setting")
    public Optional<CurrentClimateSetting> getCurrentClimateSetting() {
        return currentClimateSetting;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DeviceProperties && equalTo((DeviceProperties) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeviceProperties other) {
        return online == other.online
                && name.equals(other.name)
                && model.equals(other.model)
                && augustMetadata.equals(other.augustMetadata)
                && schlageMetadata.equals(other.schlageMetadata)
                && smartthingsMetadata.equals(other.smartthingsMetadata)
                && currentClimateSetting.equals(other.currentClimateSetting);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                this.online,
                this.name,
                this.model,
                this.augustMetadata,
                this.schlageMetadata,
                this.smartthingsMetadata,
                this.currentClimateSetting);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OnlineStage builder() {
        return new Builder();
    }

    public interface OnlineStage {
        NameStage online(boolean online);

        Builder from(DeviceProperties other);
    }

    public interface NameStage {
        ModelStage name(String name);
    }

    public interface ModelStage {
        SmartthingsMetadataStage model(DevicePropertiesModel model);
    }

    public interface SmartthingsMetadataStage {
        _FinalStage smartthingsMetadata(Object smartthingsMetadata);
    }

    public interface _FinalStage {
        DeviceProperties build();

        _FinalStage augustMetadata(Optional<AugustDeviceMetadata> augustMetadata);

        _FinalStage augustMetadata(AugustDeviceMetadata augustMetadata);

        _FinalStage schlageMetadata(Optional<SchlageDeviceMetadata> schlageMetadata);

        _FinalStage schlageMetadata(SchlageDeviceMetadata schlageMetadata);

        _FinalStage currentClimateSetting(Optional<CurrentClimateSetting> currentClimateSetting);

        _FinalStage currentClimateSetting(CurrentClimateSetting currentClimateSetting);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements OnlineStage, NameStage, ModelStage, SmartthingsMetadataStage, _FinalStage {
        private boolean online;

        private String name;

        private DevicePropertiesModel model;

        private Object smartthingsMetadata;

        private Optional<CurrentClimateSetting> currentClimateSetting = Optional.empty();

        private Optional<SchlageDeviceMetadata> schlageMetadata = Optional.empty();

        private Optional<AugustDeviceMetadata> augustMetadata = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @Override
        public Builder from(DeviceProperties other) {
            online(other.getOnline());
            name(other.getName());
            model(other.getModel());
            augustMetadata(other.getAugustMetadata());
            schlageMetadata(other.getSchlageMetadata());
            smartthingsMetadata(other.getSmartthingsMetadata());
            currentClimateSetting(other.getCurrentClimateSetting());
            return this;
        }

        @Override
        @JsonSetter("online")
        public NameStage online(boolean online) {
            this.online = online;
            return this;
        }

        @Override
        @JsonSetter("name")
        public ModelStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter("model")
        public SmartthingsMetadataStage model(DevicePropertiesModel model) {
            this.model = model;
            return this;
        }

        @Override
        @JsonSetter("smartthings_metadata")
        public _FinalStage smartthingsMetadata(Object smartthingsMetadata) {
            this.smartthingsMetadata = smartthingsMetadata;
            return this;
        }

        @Override
        public _FinalStage currentClimateSetting(CurrentClimateSetting currentClimateSetting) {
            this.currentClimateSetting = Optional.of(currentClimateSetting);
            return this;
        }

        @Override
        @JsonSetter(value = "current_climate_setting", nulls = Nulls.SKIP)
        public _FinalStage currentClimateSetting(Optional<CurrentClimateSetting> currentClimateSetting) {
            this.currentClimateSetting = currentClimateSetting;
            return this;
        }

        @Override
        public _FinalStage schlageMetadata(SchlageDeviceMetadata schlageMetadata) {
            this.schlageMetadata = Optional.of(schlageMetadata);
            return this;
        }

        @Override
        @JsonSetter(value = "schlage_metadata", nulls = Nulls.SKIP)
        public _FinalStage schlageMetadata(Optional<SchlageDeviceMetadata> schlageMetadata) {
            this.schlageMetadata = schlageMetadata;
            return this;
        }

        @Override
        public _FinalStage augustMetadata(AugustDeviceMetadata augustMetadata) {
            this.augustMetadata = Optional.of(augustMetadata);
            return this;
        }

        @Override
        @JsonSetter(value = "august_metadata", nulls = Nulls.SKIP)
        public _FinalStage augustMetadata(Optional<AugustDeviceMetadata> augustMetadata) {
            this.augustMetadata = augustMetadata;
            return this;
        }

        @Override
        public DeviceProperties build() {
            return new DeviceProperties(
                    online,
                    name,
                    model,
                    augustMetadata,
                    schlageMetadata,
                    smartthingsMetadata,
                    currentClimateSetting,
                    additionalProperties);
        }
    }
}
