/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = WorkspacesListResponse.Builder.class)
public final class WorkspacesListResponse {
    private final List<Workspace> workspaces;

    private final boolean ok;

    private final Map<String, Object> additionalProperties;

    private WorkspacesListResponse(List<Workspace> workspaces, boolean ok, Map<String, Object> additionalProperties) {
        this.workspaces = workspaces;
        this.ok = ok;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("workspaces")
    public List<Workspace> getWorkspaces() {
        return workspaces;
    }

    @JsonProperty("ok")
    public boolean getOk() {
        return ok;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof WorkspacesListResponse && equalTo((WorkspacesListResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WorkspacesListResponse other) {
        return workspaces.equals(other.workspaces) && ok == other.ok;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.workspaces, this.ok);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    public interface OkStage {
        _FinalStage ok(boolean ok);

        Builder from(WorkspacesListResponse other);
    }

    public interface _FinalStage {
        WorkspacesListResponse build();

        _FinalStage workspaces(List<Workspace> workspaces);

        _FinalStage addWorkspaces(Workspace workspaces);

        _FinalStage addAllWorkspaces(List<Workspace> workspaces);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OkStage, _FinalStage {
        private boolean ok;

        private List<Workspace> workspaces = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @Override
        public Builder from(WorkspacesListResponse other) {
            workspaces(other.getWorkspaces());
            ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter("ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllWorkspaces(List<Workspace> workspaces) {
            this.workspaces.addAll(workspaces);
            return this;
        }

        @Override
        public _FinalStage addWorkspaces(Workspace workspaces) {
            this.workspaces.add(workspaces);
            return this;
        }

        @Override
        @JsonSetter(value = "workspaces", nulls = Nulls.SKIP)
        public _FinalStage workspaces(List<Workspace> workspaces) {
            this.workspaces.clear();
            this.workspaces.addAll(workspaces);
            return this;
        }

        @Override
        public WorkspacesListResponse build() {
            return new WorkspacesListResponse(workspaces, ok, additionalProperties);
        }
    }
}
