/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable;
import io.github.senthilganeshs.fj.ds.Iterable2;
import io.github.senthilganeshs.fj.ds.List;
import io.github.senthilganeshs.fj.ds.Maybe;
import io.github.senthilganeshs.fj.ds.Tuple;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface BinaryTree<T>
extends Iterable<T>,
Comparable<T> {
    public static final BinaryTree<Integer> EMPTY = new Empty<Integer>();

    @Override
    public BinaryTree<T> build(T var1);

    default public BinaryTree<T> build(T value, Comparator<T> comparator) {
        return this.build((Object)value);
    }

    public BinaryTree<T> replaceLeft(Function<BinaryTree<T>, BinaryTree<T>> var1);

    public BinaryTree<T> replaceRight(Function<BinaryTree<T>, BinaryTree<T>> var1);

    public BinaryTree<T> swapLeft();

    public BinaryTree<T> swapRight();

    public int height();

    public boolean contains(T var1);

    @Deprecated
    public static <R extends Comparable<R>> BinaryTree<R> nil() {
        return EMPTY;
    }

    public static <R> BinaryTree<R> nil(final Comparator<R> comparator) {
        return new Empty<R>(){

            @Override
            public BinaryTree<R> build(R input) {
                return this.build(input, comparator);
            }
        };
    }

    public static <R extends Comparable<R>> BinaryTree<R> of(Collection<R> values) {
        return BinaryTree.of((r1, r2) -> r1.compareTo(r2), values);
    }

    public static <R extends Comparable<R>> BinaryTree<R> of(Iterable<R> values) {
        return BinaryTree.of((r1, r2) -> r1.compareTo(r2), values);
    }

    public static <R extends Comparable<R>> BinaryTree<R> of(R ... values) {
        return BinaryTree.of((r1, r2) -> r1.compareTo(r2), values);
    }

    public static <R> BinaryTree<R> of(Comparator<R> comparator, Iterable<R> values) {
        return values.foldl(BinaryTree.nil(comparator), (r, t) -> r.build(t));
    }

    public static <R> BinaryTree<R> of(Comparator<R> comparator, Collection<R> values) {
        Iterable<Object> tree = BinaryTree.nil(comparator);
        for (R value : values) {
            tree = tree.build((Object)value);
        }
        return tree;
    }

    public static <R> BinaryTree<R> of(Comparator<R> comparator, R ... values) {
        Iterable<Object> tree = BinaryTree.nil(comparator);
        if (values == null || values.length == 0) {
            return tree;
        }
        for (R value : values) {
            tree = tree.build((Object)value);
        }
        return tree;
    }

    default public List<T> sorted() {
        return this.foldl(List.nil(), (r, t) -> r.build(t));
    }

    public static class Empty<T>
    implements BinaryTree<T> {
        @Override
        public <R> Iterable<R> empty() {
            return BinaryTree.nil();
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, T, R> fn) {
            return seed;
        }

        @Override
        public BinaryTree<T> build(T value) {
            if (value instanceof Comparable) {
                return this.build(value, (t1, t2) -> ((Comparable)t1).compareTo(t2));
            }
            throw new IllegalArgumentException(value + " is not Comparable. Use build with comparator api");
        }

        @Override
        public BinaryTree<T> build(T value, Comparator<T> comparator) {
            return new AVLTree<T>(value, BinaryTree.nil(comparator), BinaryTree.nil(comparator), comparator);
        }

        @Override
        public BinaryTree<T> replaceLeft(Function<BinaryTree<T>, BinaryTree<T>> left) {
            return left.apply(this);
        }

        @Override
        public BinaryTree<T> replaceRight(Function<BinaryTree<T>, BinaryTree<T>> right) {
            return right.apply(this);
        }

        @Override
        public int compareTo(T o) {
            return -1;
        }

        @Override
        public int height() {
            return 0;
        }

        public String toString() {
            return "[]";
        }

        @Override
        public BinaryTree<T> swapLeft() {
            return this;
        }

        @Override
        public BinaryTree<T> swapRight() {
            return this;
        }

        @Override
        public boolean contains(T value) {
            return false;
        }
    }

    public static final class AVLTree<T>
    implements BinaryTree<T> {
        private final BinaryTree<T> right;
        private final BinaryTree<T> left;
        private final T value;
        private final Comparator<T> comparator;

        AVLTree(T value, BinaryTree<T> left, BinaryTree<T> right, Comparator<T> comparator) {
            this.value = value;
            this.left = left;
            this.right = right;
            this.comparator = comparator;
        }

        @Override
        public <R> Iterable<R> empty() {
            return BinaryTree.nil();
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, T, R> fn) {
            return this.right.foldl(fn.apply(this.left.foldl(seed, fn), this.value), fn);
        }

        @Override
        public Iterable2<Maybe<T>, Iterable<T>> unbuild() {
            Maybe succ = this.left.foldl(Maybe.nothing(), (r, t) -> Maybe.some(t));
            return Tuple.of(Maybe.some(this.value), succ.concat(this.left).concat(this.right));
        }

        @Override
        public BinaryTree<T> build(T other) {
            if (this.comparator.compare(this.value, other) == 0) {
                return this;
            }
            if (this.comparator.compare(this.value, other) > 0) {
                int rth;
                Iterable lf = this.left.build((Object)other);
                int lfh = lf.height();
                if (Math.abs(lfh - (rth = this.right.height())) == 2) {
                    if (lf.compareTo(other) > 0) {
                        return lf.replaceRight(lfrt -> new AVLTree<T>(this.value, lfrt, this.right, this.comparator));
                    }
                    return lf.swapRight().replaceRight(lfrt -> new AVLTree<T>(this.value, lfrt, this.right, this.comparator));
                }
                return new AVLTree<T>(this.value, lf, this.right, this.comparator);
            }
            Iterable rt = this.right.build((Object)other);
            int rth = rt.height();
            int lfh = this.left.height();
            if (Math.abs(lfh - rth) == 2) {
                if (rt.compareTo(other) < 0) {
                    return rt.replaceLeft(rtlf -> new AVLTree<T>(this.value, this.left, rtlf, this.comparator));
                }
                return rt.swapLeft().replaceLeft(rtlf -> new AVLTree<T>(this.value, this.left, rtlf, this.comparator));
            }
            return new AVLTree<T>(this.value, this.left, rt, this.comparator);
        }

        @Override
        public BinaryTree<T> replaceLeft(Function<BinaryTree<T>, BinaryTree<T>> left) {
            return new AVLTree<T>(this.value, left.apply(this.left), this.right, this.comparator);
        }

        @Override
        public BinaryTree<T> replaceRight(Function<BinaryTree<T>, BinaryTree<T>> right) {
            return new AVLTree<T>(this.value, this.left, right.apply(this.right), this.comparator);
        }

        @Override
        public int compareTo(T other) {
            return this.comparator.compare(this.value, other);
        }

        @Override
        public int height() {
            return 1 + Math.max(this.left.height(), this.right.height());
        }

        public String toString() {
            return String.format("{ Label : %s, left = %s, right = %s }", this.value, this.left, this.right);
        }

        @Override
        public BinaryTree<T> swapLeft() {
            return this.left.replaceRight(lfrt -> new AVLTree<T>(this.value, lfrt, this.right, this.comparator));
        }

        @Override
        public BinaryTree<T> swapRight() {
            return this.right.replaceLeft(rtlf -> new AVLTree<T>(this.value, this.left, rtlf, this.comparator));
        }

        @Override
        public boolean contains(T value) {
            if (this.comparator.compare(this.value, value) == 0) {
                return true;
            }
            if (this.comparator.compare(this.value, value) > 0) {
                return this.left.contains(value);
            }
            return this.right.contains(value);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof AVLTree) {
                return ((AVLTree)other).value.equals(this.value);
            }
            return false;
        }
    }
}

