/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface Either<A, B>
extends Iterable<B> {
    public Either<A, B> build(B var1);

    public <R> R either(Function<A, R> var1, Function<B, R> var2);

    public static <P, Q> Either<P, Q> left(P value) {
        return new Left(value);
    }

    public static <P, Q> Either<P, Q> right(Q value) {
        return new Right(value);
    }

    default public B fromRight(B def) {
        return (B)this.either(a -> def, b -> b);
    }

    default public A fromLeft(A def) {
        return (A)this.either(a -> a, b -> def);
    }

    default public boolean isLeft() {
        return this.either(a -> true, b -> false);
    }

    default public boolean isRight() {
        return this.either(a -> false, b -> true);
    }

    public static final class Right<A, B>
    implements Either<A, B> {
        private final B value;

        Right(B value) {
            this.value = value;
        }

        @Override
        public <R> Iterable<R> empty() {
            return new Left(this.value);
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, B, R> fn) {
            return fn.apply(seed, this.value);
        }

        @Override
        public Either<A, B> build(B value) {
            return new Right<A, B>(value);
        }

        @Override
        public <R> R either(Function<A, R> fa, Function<B, R> fb) {
            return fb.apply(this.value);
        }

        public String toString() {
            return "Right " + this.value;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Right) {
                Right rOther = (Right)other;
                return rOther.value.equals(this.value);
            }
            return false;
        }
    }

    public static final class Left<A, B>
    implements Either<A, B> {
        private final A value;

        Left(A value) {
            this.value = value;
        }

        @Override
        public <R> Iterable<R> empty() {
            return new Left<A, B>(this.value);
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, B, R> fn) {
            return seed;
        }

        @Override
        public Either<A, B> build(B value) {
            return new Right(value);
        }

        @Override
        public <R> R either(Function<A, R> fa, Function<B, R> fb) {
            return fa.apply(this.value);
        }

        public String toString() {
            return "Left " + this.value;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof Left) {
                Left lOther = (Left)other;
                return lOther.value.equals(this.value);
            }
            return false;
        }
    }
}

