/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.BinaryTree;
import io.github.senthilganeshs.fj.ds.Either;
import io.github.senthilganeshs.fj.ds.Iterable2;
import io.github.senthilganeshs.fj.ds.Maybe;
import io.github.senthilganeshs.fj.ds.Tuple;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Iterable<T> {
    public <R> Iterable<R> empty();

    public Iterable<T> build(T var1);

    public <R> R foldl(R var1, BiFunction<R, T, R> var2);

    default public Iterable2<Maybe<T>, Iterable<T>> unbuild() {
        return Tuple.of(Maybe.nothing(), this.empty());
    }

    default public <R> R foldr(R seed, BiFunction<T, R, R> fn) {
        Function res = this.foldl(a -> a, (g, t) -> s -> g.apply(fn.apply(t, s)));
        return res.apply(seed);
    }

    public static <R extends Comparable<R>> Iterable<R> sort(Iterable<R> iter) {
        return BinaryTree.of(iter).sorted();
    }

    public static <A, B> Iterable<A> lefts(Iterable<Either<A, B>> es) {
        return es.foldl(es.empty(), (rs, t) -> t.either(a -> rs.build(a), b -> rs));
    }

    public static <A, B> Iterable<B> rights(Iterable<Either<A, B>> es) {
        return es.foldl(es.empty(), (rs, t) -> t.either(a -> rs, b -> rs.build(b)));
    }

    public static <A, B> Tuple<Iterable<A>, Iterable<B>> partition(Iterable<Either<A, B>> es) {
        return Tuple.of(Iterable.lefts(es), Iterable.rights(es));
    }

    public static <R> Iterable<Iterable<R>> sequence(Iterable<Iterable<R>> rs) {
        return rs.traverse(id -> id);
    }

    default public Iterable2<Iterable<T>, Iterable<T>> zipper() {
        return Tuple.of(this, this.empty());
    }

    default public <R> Iterable<Iterable<R>> traverse(Function<T, Iterable<R>> fn) {
        Iterable<R> seed = this.empty();
        Iterable<Iterable<R>> sseed = seed.build(this.empty());
        return this.foldl(sseed, (rrs, t) -> ((Iterable)fn.apply(t)).liftA2((T r, R rs) -> rs.build(r), (Iterable)rrs));
    }

    default public Iterable<T> filter(Predicate<T> pred) {
        return this.foldl(this.empty(), (r, t) -> pred.test(t) ? r.build(t) : r);
    }

    default public <R, S> Iterable<S> liftA2(Function<T, Function<R, S>> fn, Iterable<R> rs) {
        return rs.apply(this.map(fn::apply));
    }

    default public <R, S> Iterable<S> liftA2(BiFunction<T, R, S> fn, Iterable<R> rs) {
        return this.liftA2((T t) -> r -> fn.apply(t, r), rs);
    }

    default public <P, Q, R> Iterable<R> liftA3(Function<T, BiFunction<P, Q, R>> fn, Iterable<P> ps, Iterable<Q> qs) {
        return this.apply(ps.liftA2((T p, R q) -> t -> ((BiFunction)fn.apply(t)).apply(p, q), qs));
    }

    default public <P, Q, R, S> Iterable<S> liftA4(Function<T, Function<P, BiFunction<Q, R, S>>> fn, Iterable<P> ps, Iterable<Q> qs, Iterable<R> rs) {
        return this.apply(ps.liftA3(p -> (q, r) -> t -> ((BiFunction)((Function)fn.apply(t)).apply(p)).apply(q, r), qs, rs));
    }

    default public <R> Iterable<R> map(Function<T, R> fn) {
        return this.foldl(this.empty(), (rs, t) -> rs.build(fn.apply(t)));
    }

    default public Iterable<T> concat(Iterable<T> first) {
        return this.foldl(first, (ts, t) -> ts.build(t));
    }

    default public <R> Iterable<R> flatMap(Function<T, Iterable<R>> fn) {
        return this.foldl(this.empty(), (rs, t) -> ((Iterable)fn.apply(t)).concat((Iterable)rs));
    }

    default public <R> Iterable<R> apply(Iterable<Function<T, R>> fns) {
        return fns.flatMap(this::map);
    }

    default public Iterable<T> forEach(Consumer<T> action) {
        return this.foldl(this, (__, t) -> {
            action.accept(t);
            return this;
        });
    }
}

