/*
 * Decompiled with CFR 0.152.
 */
package io.github.senthilganeshs.fj.ds;

import io.github.senthilganeshs.fj.ds.Iterable;
import io.github.senthilganeshs.fj.ds.Maybe;
import io.github.senthilganeshs.fj.ds.Tuple;
import java.util.function.BiFunction;

public interface List<T>
extends Iterable<T> {
    public static final List<Void> EMPTY = new EmptyList<Void>();

    @Override
    public List<T> build(T var1);

    default public int length() {
        return this.foldl(0, (r, t) -> r + 1);
    }

    default public Iterable<T> drop(int n) {
        Object[] res = new Object[]{n, this.empty()};
        return (Iterable)this.foldl(res, (r, t) -> {
            Object[] objectArray;
            if ((Integer)r[0] > 0) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = (Integer)r[0] - 1;
                objectArray = objectArray2;
                objectArray2[1] = r[1];
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = (Integer)r[0];
                objectArray = objectArray3;
                objectArray3[1] = ((Iterable)r[1]).build(t);
            }
            return objectArray;
        })[1];
    }

    default public Iterable<T> reverse() {
        return this.foldr(this.empty(), (t, r) -> r.build(t));
    }

    default public Iterable<T> take(int n) {
        Object[] res = new Object[]{n, this.empty()};
        return (Iterable)this.foldl(res, (r, t) -> {
            Object[] objectArray;
            if ((Integer)r[0] > 0) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = (Integer)r[0] - 1;
                objectArray = objectArray2;
                objectArray2[1] = ((Iterable)r[1]).build(t);
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = (Integer)r[0];
                objectArray = objectArray3;
                objectArray3[1] = r[1];
            }
            return objectArray;
        })[1];
    }

    default public Iterable<T> intersperse(T sep) {
        return this.drop(1).foldl(this.take(1), (r, t) -> r.build(sep).build(t));
    }

    public static <R> Iterable<List<R>> intercalate(List<R> rs, List<List<R>> rss) {
        return rss.drop(1).foldl(rss.take(1), (r, t) -> r.build(rs).build((List)t));
    }

    public static Boolean and(Iterable<Boolean> bools) {
        return bools.foldl(true, (r, b) -> r != false && b != false);
    }

    public static Boolean or(Iterable<Boolean> bools) {
        return bools.foldl(false, (r, b) -> r != false || b != false);
    }

    public static <R> List<R> of(java.util.List<R> list) {
        return list.stream().reduce(List.nil(), (rs, r) -> rs.build(r), (r1, r2) -> r2);
    }

    @SafeVarargs
    public static <R> List<R> of(R ... values) {
        if (values == null || values.length == 0) {
            return List.nil();
        }
        Iterable<Object> list = List.nil();
        for (R value : values) {
            list = list.build((Object)value);
        }
        return list;
    }

    public static <R> List<R> nil() {
        return EMPTY;
    }

    public static <R> List<R> cons(List<R> head, R tail) {
        return new LinkedList<R>(head, tail);
    }

    public static final class LinkedList<T>
    implements List<T> {
        private final T tail;
        private final List<T> head;

        LinkedList(List<T> head, T tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public <R> Iterable<R> empty() {
            return List.nil();
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, T, R> fn) {
            return fn.apply(this.head.foldl(seed, (r, t) -> fn.apply(r, t)), this.tail);
        }

        @Override
        public List<T> build(T input) {
            return List.cons(this, input);
        }

        @Override
        public Tuple<Maybe<T>, Iterable<T>> unbuild() {
            return Tuple.of(Maybe.some(this.tail), this.head);
        }

        public String toString() {
            return this.head.foldl("[", (r, t) -> r + t + ",") + this.tail + "]";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof LinkedList) {
                LinkedList llOther = (LinkedList)other;
                if (llOther.tail.equals(((LinkedList)other).tail)) {
                    return llOther.head.equals(this.head);
                }
            }
            return false;
        }
    }

    public static final class EmptyList<T>
    implements List<T> {
        @Override
        public <R> Iterable<R> empty() {
            return List.nil();
        }

        @Override
        public <R> R foldl(R seed, BiFunction<R, T, R> fn) {
            return seed;
        }

        @Override
        public List<T> build(T input) {
            return new LinkedList<T>(this, input);
        }

        public String toString() {
            return "";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            return other instanceof EmptyList;
        }
    }
}

