/*
 * Decompiled with CFR 0.152.
 */
package com.functional.programming.with.javabrains.exercise;

import com.functional.programming.with.javabrains.exercise.ListManipulator;
import com.functional.programming.with.javabrains.exercise.Person;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Entry {
    public static void main(String[] args) {
        List<Person> people = Arrays.asList(new Person("Monica", "Gellare", 25), new Person("Ross", "Gellar", 25), new Person("Chandler", "Bing", 25), new Person("Joseph", "Tribiani", 25), new Person("Phoebe", "Buffay", 25));
        Entry entry = new Entry();
        ListManipulator sortListByLastNameLambda = list -> {
            Collections.sort(list, new Comparator<Person>(){

                @Override
                public int compare(Person o1, Person o2) {
                    return o1.getLastName().compareTo(o2.getLastName());
                }
            });
            list.forEach(System.out::print);
        };
        System.out.println("Sorted List by Last Name: \n");
        entry.manipulateList(people, sortListByLastNameLambda);
        ListManipulator listPrinterLambda = list -> list.forEach(System.out::print);
        System.out.println("\n \n Print All the elements: \n");
        entry.manipulateList(people, listPrinterLambda);
        ListManipulator filterByLastNameLambda = list -> list.stream().filter(s -> s.getLastName().equals("Gellar")).forEach(System.out::print);
        System.out.println("\n \n List of Gellars : \n");
        entry.manipulateList(people, filterByLastNameLambda);
    }

    private void manipulateList(List<Person> people, ListManipulator manipulator) {
        manipulator.perform(people);
    }
}

