/*
 * Decompiled with CFR 0.152.
 */
package io.github.swsk33.sqlinitializespringbootstarter.autoconfigure;

import cn.hutool.core.util.StrUtil;
import io.github.swsk33.sqlinitializecore.model.ConnectionMetadata;
import io.github.swsk33.sqlinitializecore.strategy.context.MetaCheckURLContext;
import io.github.swsk33.sqlinitializecore.util.DatabaseMetadataUtils;
import io.github.swsk33.sqlinitializecore.util.SQLExecuteUtils;
import io.github.swsk33.sqlinitializespringbootstarter.properties.DatabaseInitializeProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="SQLInitializeAutoConfigure")
@EnableConfigurationProperties(value={DataSourceProperties.class, DatabaseInitializeProperties.class})
public class DatabaseInitializeAutoConfigure
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitializeAutoConfigure.class);
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private DatabaseInitializeProperties initializeProperties;

    private ConnectionMetadata parseDatasource() {
        ConnectionMetadata metadata = new ConnectionMetadata(this.dataSourceProperties.getUrl());
        log.info("\u5df2\u5b8c\u6210\u5bf9\u914d\u7f6e\u6570\u636e\u5e93\u5730\u5740\u7684\u89e3\u6790\uff01");
        log.info("\u6570\u636e\u5e93\u8f6f\u4ef6\u5e73\u53f0\uff1a{}", (Object)metadata.getDatabasePlatform());
        return metadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDatabase(ConnectionMetadata metadata) {
        if (!this.initializeProperties.isCheckDatabase()) {
            log.warn("\u5df2\u7981\u7528\u6570\u636e\u5e93\u68c0\u67e5\uff01\u5c06\u4e0d\u4f1a\u68c0\u67e5\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff0c\u76f4\u63a5\u8fdb\u884c\u8868\u683c\u521b\u5efa\u64cd\u4f5c\uff01");
            return true;
        }
        log.info("\u5f00\u59cb\u68c0\u67e5\u6570\u636e\u5e93\u662f\u5426\u9700\u8981\u521d\u59cb\u5316...");
        String checkUrl = MetaCheckURLContext.getCheckURL((ConnectionMetadata)metadata);
        if (StrUtil.isEmpty((CharSequence)checkUrl)) {
            return false;
        }
        try (Connection connection = DriverManager.getConnection(checkUrl, this.dataSourceProperties.getUsername(), this.dataSourceProperties.getPassword());){
            if (!DatabaseMetadataUtils.databaseExists((String)metadata.getDatabaseName(), (Connection)connection)) {
                log.warn("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\uff01\u51c6\u5907\u521b\u5efa\uff01");
                boolean bl2 = SQLExecuteUtils.createDatabase((String)metadata.getDatabasePlatform(), (String)metadata.getDatabaseName(), (Connection)connection);
                return bl2;
            }
            log.info("\u6570\u636e\u5e93\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u521b\u5efa\uff01");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u81f3\u6570\u636e\u5e93\u68c0\u67e5\u5143\u6570\u636e\u65f6\u5931\u8d25\uff01");
            log.error(e.getMessage());
            return false;
        }
    }

    private void createTables(ConnectionMetadata metadata) {
        try (Connection connection = DriverManager.getConnection(this.dataSourceProperties.getUrl(), this.dataSourceProperties.getUsername(), this.dataSourceProperties.getPassword());){
            if (DatabaseMetadataUtils.getDatabaseTableCount((String)metadata.getDatabaseName(), (Connection)connection) == 0) {
                log.warn("\u6570\u636e\u5e93{}\u4e2d\u6ca1\u6709\u4efb\u4f55\u8868\uff0c\u5c06\u8fdb\u884c\u521b\u5efa\uff01", (Object)metadata.getDatabaseName());
                connection.setAutoCommit(true);
                SQLExecuteUtils.batchRunSQLScript((String[])this.initializeProperties.getSqlPaths(), (Connection)connection);
                log.info("\u521d\u59cb\u5316\u8868\u683c\u5b8c\u6210\uff01");
            } else {
                log.info("\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\u8868\u683c\uff0c\u4e0d\u9700\u8981\u521b\u5efa\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u8868\u683c\u65f6\uff0c\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25\uff01");
            log.error(e.getMessage());
        }
    }

    public void afterPropertiesSet() {
        log.info("------- SQL\u81ea\u52a8\u521d\u59cb\u5316\u5f00\u59cb\u81ea\u52a8\u914d\u7f6e\u03c6(>\u03c9<*)  -------");
        if (!this.initializeProperties.isEnabled()) {
            log.warn("SQL\u81ea\u52a8\u521d\u59cb\u5316\u5df2\u7981\u7528\uff01\u5c06\u4e0d\u4f1a\u8fdb\u884c\u6570\u636e\u5e93\u68c0\u67e5\u548c\u521d\u59cb\u5316\u64cd\u4f5c\uff01");
            return;
        }
        ConnectionMetadata metadata = this.parseDatasource();
        if (this.checkDatabase(metadata)) {
            this.createTables(metadata);
        }
    }
}

