/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.base.exception.JunoApiException;
import br.com.juno.integration.api.model.Document;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.credentials.CredentialsRequest;
import br.com.juno.integration.api.services.request.document.AbstractDocumentRequest;
import br.com.juno.integration.api.services.request.document.DocumentGetRequest;
import br.com.juno.integration.api.services.request.document.DocumentListRequest;
import br.com.juno.integration.api.services.request.document.DocumentUploadEncryptedRequest;
import br.com.juno.integration.api.services.request.document.DocumentUploadRequest;
import br.com.juno.integration.api.services.response.Response;
import br.com.juno.integration.api.services.response.Responses;
import br.com.juno.integration.api.utils.CryptoUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.io.IOUtils;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public class DocumentService
extends BaseService {
    private static final String DOCUMENTS_ENDPOINT = "/documents";
    private static final String DOCUMENTS_TEMPLATED_ENDPOINT = "/documents/{id}";
    private static final String DOCUMENTS_UPLOAD_ENDPOINT = "/documents/{id}/files";

    DocumentService() {
    }

    public Document getDocument(DocumentGetRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + DOCUMENTS_TEMPLATED_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "application/json")).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Document>>(){});
        return (Document)new Response((Resource)response.getBody()).getContent();
    }

    public List<Document> listDocument(DocumentListRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + DOCUMENTS_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "application/json")).asObject((GenericType)new GenericType<Resources<Resource<Document>>>(){});
        return new Responses((Resources)response.getBody()).getAbsoluteContent();
    }

    public Document uploadDocument(DocumentUploadRequest request) {
        Document document = null;
        for (AbstractDocumentRequest.JunoFile file : request.getFiles()) {
            if (file.hasFile()) {
                document = this.uploadFile(request.getResourceToken(), (String)request.getId(), file.getFile());
            }
            if (!file.hasStream()) continue;
            document = this.uploadStream(request.getResourceToken(), (String)request.getId(), file.getStream(), file.getFileName());
        }
        return document;
    }

    private Document uploadFile(String resourceToken, String documentId, File file) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + DOCUMENTS_UPLOAD_ENDPOINT)).header("X-Resource-Token", resourceToken)).routeParam("id", documentId)).field("files", file).asObject((GenericType)new GenericType<Resource<Document>>(){});
        return (Document)new Response((Resource)response.getBody()).getContent();
    }

    private Document uploadStream(String resourceToken, String documentId, InputStream file, String fileName) {
        try {
            byte[] fileContent = new byte[file.available()];
            IOUtils.read((InputStream)file, (byte[])fileContent);
            HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + DOCUMENTS_UPLOAD_ENDPOINT)).header("X-Resource-Token", resourceToken)).routeParam("id", documentId)).multiPartContent().field("files", fileContent, fileName).asObject((GenericType)new GenericType<Resource<Document>>(){});
            return (Document)new Response((Resource)response.getBody()).getContent();
        }
        catch (IOException e) {
            throw new JunoApiException("Error uploading document", e);
        }
    }

    public Document uploadDocumentAsEncripted(DocumentUploadEncryptedRequest request) {
        PublicKey publicKey = JunoApiManager.getCredentialsService().getPublicCredentials(new CredentialsRequest(request.getResourceToken())).getPublicKey();
        byte[] encryptedFile = CryptoUtils.encryptFile(publicKey, request.getFile().getFileName(), request.getFile().getStream());
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + DOCUMENTS_UPLOAD_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-encoding", "gzip")).header("Content-type", "application/octet-stream")).routeParam("id", (String)request.getId())).body(encryptedFile).asObject((GenericType)new GenericType<Resource<Document>>(){});
        return (Document)new Response((Resource)response.getBody()).getContent();
    }
}

