/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services.request.subscriptions;

import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.BaseResourceRequest;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;

public class SubscriptionCreateRequest
extends BaseResourceRequest {
    private static final long serialVersionUID = -4614712130882760456L;
    private Integer dueDay;
    private String planId;
    private String chargeDescription;
    private final CreditCardDetails creditCardDetails;
    private final Billing billing;
    private List<Split> split = new LinkedList<Split>();

    public SubscriptionCreateRequest(Integer dueDay, String planId, String chargeDescription, CreditCardDetails creditCardDetails, Billing billing, List<Split> split) {
        this(JunoApiManager.config().getResourceToken(), dueDay, planId, chargeDescription, creditCardDetails, billing, split);
    }

    public SubscriptionCreateRequest(String resourceToken, Integer dueDay, String planId, String chargeDescription, CreditCardDetails creditCardDetails, Billing billing, List<Split> split) {
        super(resourceToken);
        this.dueDay = dueDay;
        this.planId = planId;
        this.chargeDescription = chargeDescription;
        this.creditCardDetails = creditCardDetails;
        this.billing = billing;
        this.split = split;
    }

    public CreditCardDetails getCreditCardDetails() {
        return this.creditCardDetails;
    }

    public Billing getBilling() {
        return this.billing;
    }

    public Integer getDueDay() {
        return this.dueDay;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getChargeDescription() {
        return this.chargeDescription;
    }

    public List<Split> getSplit() {
        return this.split;
    }

    public static class Split
    implements Serializable {
        private static final long serialVersionUID = -422616029724650523L;
        private String recipientToken;
        private BigDecimal amount;
        private BigDecimal percentage;
        private boolean amountRemainder;
        private boolean chargeFee;

        public Split(String recipientToken, BigDecimal amount, BigDecimal percentage, boolean amountRemainder, boolean chargeFee) {
            this.recipientToken = recipientToken;
            this.amount = amount;
            this.percentage = percentage;
            this.amountRemainder = amountRemainder;
            this.chargeFee = chargeFee;
        }

        public String getRecipientToken() {
            return this.recipientToken;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getPercentage() {
            return this.percentage;
        }

        public boolean isAmountRemainder() {
            return this.amountRemainder;
        }

        public boolean isChargeFee() {
            return this.chargeFee;
        }

        public void setRecipientToken(String recipientToken) {
            this.recipientToken = recipientToken;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setPercentage(BigDecimal percentage) {
            this.percentage = percentage;
        }

        public void setAmountRemainder(boolean amountRemainder) {
            this.amountRemainder = amountRemainder;
        }

        public void setChargeFee(boolean chargeFee) {
            this.chargeFee = chargeFee;
        }
    }

    public static class Billing
    implements Serializable {
        private static final long serialVersionUID = -6641053350149713609L;
        private String name;
        private String document;
        private String email;
        private Address address;
        private String secondaryEmail;
        private String phone;
        private Boolean notify;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        private LocalDate birthDate;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDocument() {
            return this.document;
        }

        public void setDocument(String document) {
            this.document = document;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public String getSecondaryEmail() {
            return this.secondaryEmail;
        }

        public void setSecondaryEmail(String secondaryEmail) {
            this.secondaryEmail = secondaryEmail;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public LocalDate getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
        }

        public Boolean getNotify() {
            return this.notify;
        }

        public void setNotify(Boolean notify) {
            this.notify = notify;
        }

        public static class Address
        implements Serializable {
            private static final long serialVersionUID = 550674101703674606L;
            private String street;
            private String number;
            private String complement;
            private String neighborhood;
            private String city;
            private String state;
            private String postCode;

            public String getStreet() {
                return this.street;
            }

            public String getNumber() {
                return this.number;
            }

            public String getComplement() {
                return this.complement;
            }

            public String getNeighborhood() {
                return this.neighborhood;
            }

            public String getCity() {
                return this.city;
            }

            public String getState() {
                return this.state;
            }

            public String getPostCode() {
                return this.postCode;
            }

            public void setStreet(String street) {
                this.street = street;
            }

            public void setNumber(String number) {
                this.number = number;
            }

            public void setComplement(String complement) {
                this.complement = complement;
            }

            public void setNeighborhood(String neighborhood) {
                this.neighborhood = neighborhood;
            }

            public void setCity(String city) {
                this.city = city;
            }

            public void setState(String state) {
                this.state = state;
            }

            public void setPostCode(String postCode) {
                this.postCode = postCode;
            }
        }
    }

    public static class CreditCardDetails
    implements Serializable {
        private static final long serialVersionUID = -8367973883572221156L;
        private final String creditCardId;
        private String creditCardHash;

        public CreditCardDetails(String creditCardId) {
            this.creditCardId = creditCardId;
        }

        public String getCreditCardId() {
            return this.creditCardId;
        }

        public String getCreditCardHash() {
            return this.creditCardHash;
        }
    }
}

