/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.model;

import br.com.juno.integration.api.base.Clock;
import br.com.juno.integration.api.base.exception.Assert;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public final class AuthorizationToken
implements Serializable {
    private static final long serialVersionUID = -8061124453931068922L;
    private final Long timestamp = Clock.getTimeInMillis();
    private String accessToken;
    private String tokenType;
    private Long expiresIn;
    private String scope;
    private String userName;
    private String jti;

    protected AuthorizationToken() {
    }

    public boolean isExpired() {
        return this.isExpired(0L);
    }

    public boolean isExpired(Long minTimeAmount) {
        Assert.notNull(this.expiresIn, "expiredIn was not initialized", new Object[0]);
        return Clock.getTimeInMillis() - this.timestamp > this.getExpiresInMillis() - minTimeAmount;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public Long getExpiresInMillis() {
        return this.expiresIn == null ? null : Long.valueOf(this.expiresIn * 1000L);
    }

    public String getScope() {
        return this.scope;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getJti() {
        return this.jti;
    }

    @JsonProperty(value="access_token")
    void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JsonProperty(value="token_type")
    void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @JsonProperty(value="expires_in")
    void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonProperty(value="scope")
    void setScope(String scope) {
        this.scope = scope;
    }

    @JsonProperty(value="user_name")
    void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonProperty(value="jti")
    void setJti(String jti) {
        this.jti = jti;
    }
}

