/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.model.AuthorizationToken;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiConfig;
import br.com.juno.integration.api.services.JunoApiManager;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public final class AuthorizationService
extends BaseService {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER = "Bearer ";
    public static final String OAUTH_TOKEN_ENDPOINT = "/oauth/token";
    private AuthorizationToken authorizationToken;

    public synchronized String getToken() {
        if (this.authorizationToken == null || this.authorizationToken.isExpired(JunoApiConfig.TOKEN_TIMEOUT)) {
            this.refresh();
        }
        return this.authorizationToken.getAccessToken();
    }

    public Map<String, String> getAuthorizationHeader() {
        HashMap<String, String> authorizationHeader = new HashMap<String, String>();
        authorizationHeader.put(AUTHORIZATION_HEADER, BEARER + this.getToken());
        return authorizationHeader;
    }

    private void refresh() {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getAuthorizationEndpoint() + OAUTH_TOKEN_ENDPOINT)).basicAuth(JunoApiManager.config().getClientId(), JunoApiManager.config().getClientSecret())).header("Content-type", "application/x-www-form-urlencoded")).field("grant_type", (Object)"client_credentials").asObject(AuthorizationToken.class);
        this.authorizationToken = (AuthorizationToken)response.getBody();
    }
}

