/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.base.exception.JunoApiException;
import br.com.juno.integration.api.model.Charge;
import br.com.juno.integration.api.model.LabeledEnum;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.charge.ChargeCreateRequest;
import br.com.juno.integration.api.services.request.charge.ChargeListRequest;
import br.com.juno.integration.api.services.response.Responses;
import br.com.juno.integration.api.utils.JacksonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public final class ChargeService
extends BaseService {
    private static final String CHARGES_ENDPOINT = "/charges";

    ChargeService() {
    }

    public List<Charge> create(ChargeCreateRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + CHARGES_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "application/json")).body(JacksonUtils.toJson(request)).asObject((GenericType)new GenericType<Resources<Resource<Charge>>>(){});
        return new Responses((Resources)response.getBody()).getAbsoluteContent();
    }

    public Responses<Charge> list(ChargeListRequest request) {
        GetRequest httpRequest = (GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + CHARGES_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "application/json");
        this.populateParameters((HttpRequest<GetRequest>)httpRequest, request);
        return this.exchange(httpRequest);
    }

    public Responses<Charge> listNextPage(Responses<Charge> currentPage) {
        Responses<Charge> responses = null;
        if (StringUtils.isNotBlank((CharSequence)currentPage.getHrefNext())) {
            responses = this.getPage(currentPage.getResourceToken(), currentPage.getHrefNext());
        }
        return responses != null ? responses : new Responses<Charge>(new LinkedList(), currentPage.getResourceToken());
    }

    private Responses<Charge> getPage(String resourceToken, String hateoasLink) {
        GetRequest httpRequest = (GetRequest)((GetRequest)Unirest.get((String)hateoasLink).header("X-Resource-Token", resourceToken)).header("Content-type", "application/json");
        return this.exchange(httpRequest);
    }

    private Responses<Charge> exchange(GetRequest httpRequest) {
        HttpResponse response = httpRequest.asObject((GenericType)new GenericType<Resources<Resource<Charge>>>(){});
        return new Responses<Charge>((Resources)response.getBody(), httpRequest.getHeaders().getFirst("X-Resource-Token"));
    }

    private void populateParameters(HttpRequest<GetRequest> httpRequest, ChargeListRequest request) {
        try {
            Field[] fields;
            for (Field field : fields = request.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!this.isNonStaticFinal(field) || field.get(request) == null) continue;
                if (field.getType().isEnum()) {
                    httpRequest.queryString(field.getName(), (Object)((LabeledEnum)field.get(request)).getLabel());
                    continue;
                }
                httpRequest.queryString(field.getName(), field.get(request));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JunoApiException(e);
        }
    }

    private boolean isNonStaticFinal(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }
}

