/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.base.exception.JunoApiException;
import br.com.juno.integration.api.model.BaseModel;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.credentials.CredentialsRequest;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class CredentialsService
extends BaseService {
    private static final String CREDENTIALS_ENDPOINT = "/credentials/public-key";

    CredentialsService() {
    }

    public JunoPublicKey getPublicCredentials(CredentialsRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + CREDENTIALS_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "text/plain")).asString();
        return new JunoPublicKey((String)response.getBody());
    }

    public static final class JunoPublicKey
    extends BaseModel {
        private static final long serialVersionUID = -422114191065898285L;
        private static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\n";
        private static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----\n";
        private final String key;

        protected JunoPublicKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public PublicKey getPublicKey() {
            try {
                String publicKey = this.key.replace(BEGIN_PUBLIC_KEY, "").replace(END_PUBLIC_KEY, "");
                byte[] encodedPublicKey = Base64.getMimeDecoder().decode(publicKey);
                X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedPublicKey);
                KeyFactory kf = KeyFactory.getInstance("RSA");
                return kf.generatePublic(spec);
            }
            catch (Exception e) {
                throw new JunoApiException("Error retrieving public key", e);
            }
        }
    }
}

