/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.model.Bank;
import br.com.juno.integration.api.model.BusinessArea;
import br.com.juno.integration.api.model.CompanyType;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.response.Responses;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public final class DataService
extends BaseService {
    private static final String DATA_ENDPOINT = "/data";
    private static final String BANKS_ENDPOINT = "/data/banks";
    private static final String COMPANY_TYPES_ENDPOINT = "/data/company-types";
    private static final String BUSINESS_AREAS_ENDPOINT = "/data/business-areas";
    private BaseService.CachedResource<Bank> banks = new BaseService.CachedResource();
    private BaseService.CachedResource<CompanyType> companyTypes = new BaseService.CachedResource();
    private BaseService.CachedResource<BusinessArea> businessAreas = new BaseService.CachedResource();

    DataService() {
    }

    public List<Bank> getBanks() {
        if (this.banks.isExpired()) {
            HttpResponse response = ((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + BANKS_ENDPOINT)).header("Content-type", "application/json")).asObject((GenericType)new GenericType<Resources<Resource<Bank>>>(){});
            this.banks.setCache(new Responses((Resources)response.getBody()).getAbsoluteContent());
        }
        return this.banks.getCache();
    }

    public List<CompanyType> getCompanyTypes() {
        if (this.companyTypes.isExpired()) {
            HttpResponse response = ((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + COMPANY_TYPES_ENDPOINT)).header("Content-type", "application/json")).asJson();
            this.companyTypes.getCache().clear();
            ((JsonNode)response.getBody()).getObject().getJSONArray("companyTypes").forEach(str -> this.companyTypes.getCache().add(new CompanyType((String)str)));
            this.companyTypes.resetTimestamp();
        }
        return this.companyTypes.getCache();
    }

    public List<BusinessArea> getBusinessAreas() {
        if (this.businessAreas.isExpired()) {
            HttpResponse response = ((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + BUSINESS_AREAS_ENDPOINT)).header("Content-type", "application/json")).asObject((GenericType)new GenericType<Resources<Resource<BusinessArea>>>(){});
            this.businessAreas.setCache(new Responses((Resources)response.getBody()).getAbsoluteContent());
        }
        return this.businessAreas.getCache();
    }
}

