/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.model.EventType;
import br.com.juno.integration.api.model.Webhook;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.notification.webhook.WebhookCreateRequest;
import br.com.juno.integration.api.services.request.notification.webhook.WebhookDeleteRequest;
import br.com.juno.integration.api.services.request.notification.webhook.WebhookFindRequest;
import br.com.juno.integration.api.services.request.notification.webhook.WebhookListRequest;
import br.com.juno.integration.api.services.request.notification.webhook.WebhookUpdateRequest;
import br.com.juno.integration.api.services.response.Response;
import br.com.juno.integration.api.services.response.Responses;
import br.com.juno.integration.api.utils.JacksonUtils;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public class NotificationService
extends BaseService {
    private static final String NOTIFICATIONS_ENDPOINT = "/notifications";
    private static final String EVENT_TYPES_ENDPOINT = "/notifications/event-types";
    private static final String WEBHOOKS_ENDPOINT = "/notifications/webhooks";
    private static final String WEBHOOKS_TEMPLATED_ENDPOINT = "/notifications/webhooks/{id}";
    private BaseService.CachedResource<EventType> eventTypes = new BaseService.CachedResource();

    public List<EventType> listEventTypes() {
        if (this.eventTypes.isExpired()) {
            HttpResponse response = ((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + EVENT_TYPES_ENDPOINT)).header("Content-type", "application/json")).asObject((GenericType)new GenericType<Resources<Resource<EventType>>>(){});
            this.eventTypes.setCache(new Responses((Resources)response.getBody()).getAbsoluteContent());
        }
        return this.eventTypes.getCache();
    }

    public List<Webhook> listWebhooks(WebhookListRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + WEBHOOKS_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).asObject((GenericType)new GenericType<Resources<Resource<Webhook>>>(){});
        return new Responses((Resources)response.getBody()).getAbsoluteContent();
    }

    public Webhook createWebhook(WebhookCreateRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + WEBHOOKS_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).body(JacksonUtils.toJson(request)).asObject((GenericType)new GenericType<Resource<Webhook>>(){});
        return (Webhook)new Response((Resource)response.getBody()).getContent();
    }

    public Webhook findWebhook(WebhookFindRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + WEBHOOKS_TEMPLATED_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Webhook>>(){});
        return (Webhook)new Response((Resource)response.getBody()).getContent();
    }

    public void deleteWebhook(WebhookDeleteRequest request) {
        ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.delete((String)(JunoApiManager.config().getResourceEndpoint() + WEBHOOKS_TEMPLATED_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asEmpty();
    }

    public Webhook updateWebhook(WebhookUpdateRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.patch((String)(JunoApiManager.config().getResourceEndpoint() + WEBHOOKS_TEMPLATED_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).body(JacksonUtils.toJson(request)).asObject((GenericType)new GenericType<Resource<Webhook>>(){});
        return (Webhook)new Response((Resource)response.getBody()).getContent();
    }
}

