/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.model.Plan;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.plans.PlanCreateRequest;
import br.com.juno.integration.api.services.request.plans.PlanListRequest;
import br.com.juno.integration.api.services.request.plans.PlanRequest;
import br.com.juno.integration.api.services.response.Response;
import br.com.juno.integration.api.services.response.Responses;
import br.com.juno.integration.api.utils.JacksonUtils;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public class PlanService
extends BaseService {
    private static final String PLANS_ENDPOINT = "/plans";
    private static final String PLANS_TEMPLATED_ENDPOINT = "/plans/{id}";

    PlanService() {
    }

    public Plan createPlan(PlanCreateRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + PLANS_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).body(JacksonUtils.toJson(request)).asObject((GenericType)new GenericType<Resource<Plan>>(){});
        return (Plan)new Response((Resource)response.getBody()).getContent();
    }

    public List<Plan> listPlans(PlanListRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + PLANS_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "application/json")).asObject((GenericType)new GenericType<Resources<Resource<Plan>>>(){});
        return new Responses((Resources)response.getBody()).getAbsoluteContent();
    }

    public Plan findPlan(PlanRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + PLANS_TEMPLATED_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Plan>>(){});
        return (Plan)new Response((Resource)response.getBody()).getContent();
    }

    public Plan deactivePlan(PlanRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + "/plans/{id}/deactivation")).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Plan>>(){});
        return (Plan)new Response((Resource)response.getBody()).getContent();
    }

    public Plan activePlan(PlanRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + "/plans/{id}/activation")).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Plan>>(){});
        return (Plan)new Response((Resource)response.getBody()).getContent();
    }
}

