/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services.request.billpayment;

import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.BaseResourceRequest;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class RegisterBillPaymentRequest
extends BaseResourceRequest {
    private static final long serialVersionUID = -8913714640641753259L;
    private final String beneficiaryDocument;
    private final BigDecimal billAmount;
    private final String numericalBarCode;
    private final BigDecimal paidAmount;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private final LocalDate paymentDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private final LocalDate dueDate;
    private String paymentDescription;

    public RegisterBillPaymentRequest(String beneficiaryDocument, BigDecimal billAmount, LocalDate dueDate, String numericalBarCode, BigDecimal paidAmount, LocalDate paymentDate) {
        this(beneficiaryDocument, billAmount, dueDate, numericalBarCode, paidAmount, paymentDate, JunoApiManager.config().getResourceToken());
    }

    public RegisterBillPaymentRequest(String beneficiaryDocument, BigDecimal billAmount, LocalDate dueDate, String numericalBarCode, BigDecimal paidAmount, LocalDate paymentDate, String resourceToken) {
        super(resourceToken);
        this.beneficiaryDocument = beneficiaryDocument;
        this.billAmount = billAmount;
        this.dueDate = dueDate;
        this.numericalBarCode = numericalBarCode;
        this.paidAmount = paidAmount;
        this.paymentDate = paymentDate;
    }

    public String getBeneficiaryDocument() {
        return this.beneficiaryDocument;
    }

    public BigDecimal getBillAmount() {
        return this.billAmount;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public String getNumericalBarCode() {
        return this.numericalBarCode;
    }

    public BigDecimal getPaidAmount() {
        return this.paidAmount;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public String getPaymentDescription() {
        return this.paymentDescription;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.beneficiaryDocument);
        builder.append((Object)this.billAmount);
        builder.append((Object)this.dueDate);
        builder.append((Object)this.numericalBarCode);
        builder.append((Object)this.paidAmount);
        builder.append((Object)this.paymentDate);
        builder.append((Object)this.paymentDescription);
        return builder.toString();
    }
}

