/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services.response;

import br.com.juno.integration.api.services.response.Response;
import br.com.juno.integration.api.utils.ResponseUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public final class Responses<T> {
    private final Resources<Resource<T>> resources;
    private String resourceToken;

    public Responses(Resources<Resource<T>> resources) {
        this.resources = resources;
    }

    public Responses(Resources<Resource<T>> resources, String resourceToken) {
        this(resources);
        this.resourceToken = resourceToken;
    }

    public Responses(List<Responses<T>> pagedResponses, String resourceToken) {
        List flattenResources = pagedResponses.stream().flatMap(responses -> responses.getContent().stream()).map(Response::getResource).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(pagedResponses)) {
            Responses<T> lastResponse = pagedResponses.get(!pagedResponses.isEmpty() ? pagedResponses.size() - 1 : pagedResponses.size());
            this.resources = new Resources(flattenResources, lastResponse.getLinks());
        } else {
            this.resources = new Resources(new LinkedList(), new Link[0]);
        }
        this.resourceToken = resourceToken;
    }

    public List<Response<T>> getContent() {
        return this.resources.getContent().stream().map(Response::new).collect(Collectors.toList());
    }

    public List<T> getAbsoluteContent() {
        return this.resources.getContent().stream().map(Resource::getContent).collect(Collectors.toList());
    }

    public void setResourceToken(String resourceToken) {
        this.resourceToken = resourceToken;
    }

    public String getResourceToken() {
        return this.resourceToken;
    }

    private List<Link> getLinks() {
        return Arrays.asList(this.getSelfLink(), this.getPreviousLink(), this.getNextLink()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasNext() {
        return this.hasResources() && this.getNextLink() != null;
    }

    public boolean hasResources() {
        return this.resources != null && CollectionUtils.isNotEmpty((Collection)this.resources.getContent());
    }

    private Link getSelfLink() {
        return ResponseUtils.getLink(this.resources, "self");
    }

    private Link getNextLink() {
        return ResponseUtils.getLink(this.resources, "next");
    }

    private Link getPreviousLink() {
        return ResponseUtils.getLink(this.resources, "previous");
    }

    public String getHrefSelf() {
        return ResponseUtils.getHrefLink(this.resources, "self");
    }

    public String getHrefNext() {
        return ResponseUtils.getHrefLink(this.resources, "next");
    }

    public String getHrefPrevious() {
        return ResponseUtils.getHrefLink(this.resources, "previous");
    }
}

