/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.config.UnirestConfig;
import org.apache.commons.lang3.StringUtils;

public final class JunoApiConfig {
    public static final Long TOKEN_TIMEOUT = 5000L;
    public static final Long CACHE_TIMEOUT = 21600000L;
    private String clientId;
    private String clientSecret;
    private String resourceToken;
    private String publicToken;
    private Environment env;

    JunoApiConfig() {
        this.sandbox();
        UnirestConfig.configure();
    }

    public JunoApiConfig production() {
        this.env = new ProductionEnviroment();
        return this;
    }

    public JunoApiConfig sandbox() {
        this.env = new SandboxEnvironment();
        return this;
    }

    public JunoApiConfig development() {
        this.env = new DevelopmentEnviroment();
        return this;
    }

    public JunoApiConfig unitTests() {
        this.env = new UnitTestEnviroment();
        return this;
    }

    public JunoApiConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public JunoApiConfig setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public JunoApiConfig setResourceToken(String resourceToken) {
        this.resourceToken = resourceToken;
        return this;
    }

    public JunoApiConfig setPublicToken(String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    public Environment getEnv() {
        return this.env;
    }

    public String getAuthorizationEndpoint() {
        return this.env.getAuthorizationServerEndpoint();
    }

    public String getResourceEndpoint() {
        return this.env.getResourceServerEndpoint();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getResourceToken() {
        return this.resourceToken;
    }

    public String getPublicToken() {
        return this.publicToken;
    }

    public boolean hasPublicTokenConfigured() {
        return StringUtils.isNotBlank((CharSequence)this.publicToken);
    }

    public boolean isCredentialsComplete() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.clientId, this.clientSecret, this.resourceToken});
    }

    public boolean isConfigured() {
        return this.isCredentialsComplete() && this.env != null;
    }

    public static class ProductionEnviroment
    implements Environment {
        private static final String AUTHORIZATION_SERVER = "https://api.juno.com.br/authorization-server";
        private static final String RESOURCE_SERVER = "https://api.juno.com.br";

        @Override
        public String getAuthorizationServerEndpoint() {
            return AUTHORIZATION_SERVER;
        }

        @Override
        public String getResourceServerEndpoint() {
            return RESOURCE_SERVER;
        }
    }

    public static class SandboxEnvironment
    implements Environment {
        private static final String AUTHORIZATION_SERVER = "https://sandbox.boletobancario.com/authorization-server";
        private static final String RESOURCE_SERVER = "https://sandbox.boletobancario.com/api-integration";

        @Override
        public String getAuthorizationServerEndpoint() {
            return AUTHORIZATION_SERVER;
        }

        @Override
        public String getResourceServerEndpoint() {
            return RESOURCE_SERVER;
        }
    }

    public static class DevelopmentEnviroment
    implements Environment {
        private static final String AUTHORIZATION_SERVER = "http://localhost:8084";
        private static final String RESOURCE_SERVER = "http://localhost:8082";

        @Override
        public String getAuthorizationServerEndpoint() {
            return AUTHORIZATION_SERVER;
        }

        @Override
        public String getResourceServerEndpoint() {
            return RESOURCE_SERVER;
        }
    }

    public static class UnitTestEnviroment
    implements Environment {
        private static final String AUTHORIZATION_SERVER = "http://localhost:8888";
        private static final String RESOURCE_SERVER = "http://localhost:8888";

        @Override
        public String getAuthorizationServerEndpoint() {
            return "http://localhost:8888";
        }

        @Override
        public String getResourceServerEndpoint() {
            return "http://localhost:8888";
        }
    }

    public static interface Environment {
        public String getAuthorizationServerEndpoint();

        public String getResourceServerEndpoint();
    }
}

