/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.model.Subscription;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.subscriptions.SubscriptionCreateRequest;
import br.com.juno.integration.api.services.request.subscriptions.SubscriptionListRequest;
import br.com.juno.integration.api.services.request.subscriptions.SubscriptionRequest;
import br.com.juno.integration.api.services.response.Response;
import br.com.juno.integration.api.services.response.Responses;
import br.com.juno.integration.api.utils.JacksonUtils;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;

public class SubscriptionService
extends BaseService {
    public static final String SUBSCRIPTIONS_ENDPOINT = "/subscriptions";
    public static final String SUBSCRIPTIONS_TEMPLATE_ENDPOINT = "/subscriptions/{id}";

    SubscriptionService() {
    }

    public Subscription createSubscription(SubscriptionCreateRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + SUBSCRIPTIONS_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).body(JacksonUtils.toJson(request)).asObject((GenericType)new GenericType<Resource<Subscription>>(){});
        return (Subscription)new Response((Resource)response.getBody()).getContent();
    }

    public List<Subscription> listSubscriptions(SubscriptionListRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + SUBSCRIPTIONS_ENDPOINT)).header("X-Resource-Token", request.getResourceToken())).header("Content-type", "application/json")).asObject((GenericType)new GenericType<Resources<Resource<Subscription>>>(){});
        return new Responses((Resources)response.getBody()).getAbsoluteContent();
    }

    public Subscription findSubscription(SubscriptionRequest request) {
        HttpResponse response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(JunoApiManager.config().getResourceEndpoint() + SUBSCRIPTIONS_TEMPLATE_ENDPOINT)).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Subscription>>(){});
        return (Subscription)new Response((Resource)response.getBody()).getContent();
    }

    public Subscription deactiveSubscription(SubscriptionRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + "/subscriptions/{id}/deactivation")).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Subscription>>(){});
        return (Subscription)new Response((Resource)response.getBody()).getContent();
    }

    public Subscription activeSubscription(SubscriptionRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + "/subscriptions/{id}/activation")).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Subscription>>(){});
        return (Subscription)new Response((Resource)response.getBody()).getContent();
    }

    public Subscription cancelSubscription(SubscriptionRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + "/subscriptions/{id}/cancelation")).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Subscription>>(){});
        return (Subscription)new Response((Resource)response.getBody()).getContent();
    }

    public Subscription completeSubscription(SubscriptionRequest request) {
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + "/subscriptions/{id}/completion")).header("Content-type", "application/json")).header("X-Resource-Token", request.getResourceToken())).routeParam("id", (String)request.getId())).asObject((GenericType)new GenericType<Resource<Subscription>>(){});
        return (Subscription)new Response((Resource)response.getBody()).getContent();
    }
}

