/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.utils;

import br.com.juno.integration.api.base.exception.JunoApiException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public final class JacksonUtils {
    private static ObjectMapper mapper;

    private JacksonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            mapper = Jackson2ObjectMapperBuilder.json().modules(new Module[]{new ParameterNamesModule(), new Jdk8Module(), new JavaTimeModule(), new Jackson2HalModule()}).mixIn(Resource.class, ResourceMixIn.class).failOnUnknownProperties(true).serializationInclusion(JsonInclude.Include.NON_NULL).build();
        }
        return mapper;
    }

    public static String toJson(Object object) {
        try {
            return JacksonUtils.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JunoApiException("Error generating JSON Payload", e);
        }
    }

    public static byte[] toJsonBytes(Object object) {
        try {
            return JacksonUtils.getObjectMapper().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JunoApiException("Error generating JSON Payload", e);
        }
    }

    private static abstract class ResourceMixIn
    extends ResourceSupport {
        private ResourceMixIn() {
        }

        @JsonIgnore(value=false)
        public abstract Link getId();
    }
}

