/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.base.exception;

import br.com.juno.integration.api.base.exception.JunoApiException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class Assert {
    private Assert() {
    }

    public static void isNull(Object obj, String errorMessage, Object ... messageParameters) {
        Assert.isTrue(obj == null, errorMessage, messageParameters);
    }

    public static void notNull(Object obj, String errorMessage, Object ... messageParameters) {
        Assert.isTrue(obj != null, errorMessage, messageParameters);
    }

    public static void notEmpty(Collection<?> col, String errorMessage, Object ... messageParameters) {
        Assert.isTrue(CollectionUtils.isNotEmpty(col), errorMessage, messageParameters);
    }

    public static void notBlank(CharSequence str, String errorMessage, Object ... messageParameters) {
        Assert.isTrue(StringUtils.isNotBlank((CharSequence)str), errorMessage, messageParameters);
    }

    public static void isTrue(boolean condition, String errorMessage, Object ... messageParameters) {
        if (!condition) {
            throw new JunoApiException(String.format(errorMessage, messageParameters));
        }
    }
}

