/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.config;

import br.com.juno.integration.api.base.exception.JunoApiException;
import br.com.juno.integration.api.utils.JacksonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.Type;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;

public final class ObjectMapperConfig {
    private ObjectMapperConfig() {
    }

    public static ObjectMapper objectMapper() {
        return new ObjectMapper(){

            public String writeValue(Object value) {
                try {
                    return JacksonUtils.getObjectMapper().writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new JunoApiException(e);
                }
            }

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)JacksonUtils.getObjectMapper().readValue(value, valueType);
                }
                catch (JsonProcessingException e) {
                    throw new JunoApiException(e);
                }
            }

            public <T> T readValue(String value, final GenericType<T> genericType) {
                try {
                    return (T)JacksonUtils.getObjectMapper().readValue(value, new TypeReference<T>(){

                        public Type getType() {
                            return genericType.getType();
                        }
                    });
                }
                catch (JsonProcessingException e) {
                    throw new JunoApiException(e);
                }
            }
        };
    }
}

