/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.base.exception.Assert;
import br.com.juno.integration.api.model.TokenizedCreditCard;
import br.com.juno.integration.api.services.BaseService;
import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.creditcard.CreditCardTokenizationRequest;
import br.com.juno.integration.api.services.response.Response;
import br.com.juno.integration.api.utils.JacksonUtils;
import java.util.HashMap;
import kong.unirest.GenericType;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.springframework.hateoas.Resource;

public class CreditCardService
extends BaseService {
    private static final String CREDIT_CARDS_ENDPOINT = "/credit-cards/tokenization";

    CreditCardService() {
    }

    public TokenizedCreditCard tokenize(CreditCardTokenizationRequest request) {
        Assert.isTrue(JunoApiManager.config().hasPublicTokenConfigured(), "To perform this operation your Public Token must be configured, check our integration manual to see how to generate the Public Token", new Object[0]);
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("creditCardHash", request.getCreditCardHash());
        HttpResponse response = ((HttpRequestWithBody)((HttpRequestWithBody)Unirest.post((String)(JunoApiManager.config().getResourceEndpoint() + CREDIT_CARDS_ENDPOINT)).header("X-Resource-Token", JunoApiManager.config().getResourceToken())).header("Content-type", "application/json")).body(JacksonUtils.toJson(request)).asObject((GenericType)new GenericType<Resource<TokenizedCreditCard>>(){});
        return (TokenizedCreditCard)new Response((Resource)response.getBody()).getContent();
    }
}

