/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services.request.charge;

import br.com.juno.integration.api.services.JunoApiManager;
import br.com.juno.integration.api.services.request.BaseResourceRequest;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class ChargeCreateRequest
extends BaseResourceRequest {
    private static final long serialVersionUID = 7287757661166353769L;
    private final Charge charge;
    private final Billing billing;

    public ChargeCreateRequest(Charge charge, Billing billing) {
        this(JunoApiManager.config().getResourceToken(), charge, billing);
    }

    public ChargeCreateRequest(String resourceToken, Charge charge, Billing billing) {
        super(resourceToken);
        this.charge = charge;
        this.billing = billing;
    }

    public Charge getCharge() {
        return this.charge;
    }

    public Billing getBilling() {
        return this.billing;
    }

    public static class Billing
    implements Serializable {
        private static final long serialVersionUID = -399033998073996520L;
        private String name;
        private String document;
        private String email;
        private Address address;
        private String secondaryEmail;
        private String phone;
        private Boolean notify;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        private LocalDate birthDate;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDocument() {
            return this.document;
        }

        public void setDocument(String document) {
            this.document = document;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public String getSecondaryEmail() {
            return this.secondaryEmail;
        }

        public void setSecondaryEmail(String secondaryEmail) {
            this.secondaryEmail = secondaryEmail;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public LocalDate getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
        }

        public Boolean getNotify() {
            return this.notify;
        }

        public void setNotify(Boolean notify) {
            this.notify = notify;
        }

        public static class Address
        implements Serializable {
            private static final long serialVersionUID = -399033998073996520L;
            private String street;
            private String number;
            private String complement;
            private String neighborhood;
            private String city;
            private String state;
            private String postCode;

            public String getStreet() {
                return this.street;
            }

            public String getNumber() {
                return this.number;
            }

            public String getComplement() {
                return this.complement;
            }

            public String getNeighborhood() {
                return this.neighborhood;
            }

            public String getCity() {
                return this.city;
            }

            public String getState() {
                return this.state;
            }

            public String getPostCode() {
                return this.postCode;
            }

            public void setStreet(String street) {
                this.street = street;
            }

            public void setNumber(String number) {
                this.number = number;
            }

            public void setComplement(String complement) {
                this.complement = complement;
            }

            public void setNeighborhood(String neighborhood) {
                this.neighborhood = neighborhood;
            }

            public void setCity(String city) {
                this.city = city;
            }

            public void setState(String state) {
                this.state = state;
            }

            public void setPostCode(String postCode) {
                this.postCode = postCode;
            }
        }
    }

    public static class Charge
    implements Serializable {
        private static final long serialVersionUID = 209164858682596232L;
        private String description;
        private Integer installments;
        private Integer maxOverdueDays;
        private Integer discountDays;
        private BigDecimal totalAmount;
        private BigDecimal amount;
        private BigDecimal fine;
        private BigDecimal interest;
        private BigDecimal discountAmount;
        private Boolean paymentAdvance;
        private List<String> references = new LinkedList<String>();
        private Set<PaymentType> paymentTypes = new HashSet<PaymentType>();
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        private LocalDate dueDate;

        public Charge(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getReferences() {
            return this.references;
        }

        public BigDecimal getTotalAmount() {
            return this.totalAmount;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public LocalDate getDueDate() {
            return this.dueDate;
        }

        public Integer getInstallments() {
            return this.installments;
        }

        public Integer getMaxOverdueDays() {
            return this.maxOverdueDays;
        }

        public BigDecimal getFine() {
            return this.fine;
        }

        public BigDecimal getInterest() {
            return this.interest;
        }

        public BigDecimal getDiscountAmount() {
            return this.discountAmount;
        }

        public Integer getDiscountDays() {
            return this.discountDays;
        }

        public Set<PaymentType> getPaymentTypes() {
            return this.paymentTypes;
        }

        public Boolean getPaymentAdvance() {
            return this.paymentAdvance;
        }

        public void setInstallments(Integer installments) {
            this.installments = installments;
        }

        public void setMaxOverdueDays(Integer maxOverdueDays) {
            this.maxOverdueDays = maxOverdueDays;
        }

        public void setDiscountDays(Integer discountDays) {
            this.discountDays = discountDays;
        }

        public void setTotalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setFine(BigDecimal fine) {
            this.fine = fine;
        }

        public void setInterest(BigDecimal interest) {
            this.interest = interest;
        }

        public void setDiscountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
        }

        public void setPaymentAdvance(Boolean paymentAdvance) {
            this.paymentAdvance = paymentAdvance;
        }

        public void setDueDate(LocalDate dueDate) {
            this.dueDate = dueDate;
        }

        public static enum PaymentType {
            BOLETO,
            CREDIT_CARD;

        }
    }
}

