/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.services;

import br.com.juno.integration.api.base.Clock;
import br.com.juno.integration.api.services.JunoApiConfig;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseService {
    protected BaseService() {
    }

    public static class CachedResource<T> {
        private Long timestamp = 0L;
        private List<T> cache = new LinkedList<T>();

        public void setCache(List<T> cache) {
            this.cache = cache;
            this.resetTimestamp();
        }

        public List<T> getCache() {
            return this.cache;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean isExpired() {
            return Clock.getTimeInMillis() - this.timestamp > JunoApiConfig.CACHE_TIMEOUT;
        }

        public void resetTimestamp() {
            this.setTimestamp(Clock.getTimeInMillis());
        }
    }
}

