/*
 * Decompiled with CFR 0.152.
 */
package br.com.juno.integration.api.utils;

import br.com.juno.integration.api.base.exception.JunoApiException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.io.IOUtils;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

public final class CryptoUtils {
    private CryptoUtils() {
    }

    public static String encryptCreditCard(PublicKey publicKey, byte[] creditCardData) {
        try {
            OAEPParameterSpec parameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPPadding");
            cipher.init(1, (Key)publicKey, parameterSpec);
            byte[] encryptedBytes = cipher.doFinal(creditCardData);
            return Base64.getEncoder().encodeToString(encryptedBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new JunoApiException("Error encrypting credit card data", e);
        }
    }

    public static byte[] encryptFile(PublicKey publicKey, String fileName, InputStream file) {
        String fileContent = CryptoUtils.encodeBase64File(file);
        String content = CryptoUtils.generateJsonSpecification(fileName, fileContent);
        String jweToken = CryptoUtils.generateJweToken(publicKey, content);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CryptoUtils.compressJwe(output, jweToken);
        return output.toByteArray();
    }

    private static String generateJsonSpecification(String fileName, String fileContent) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fn", fileName);
        map.put("fc", fileContent);
        return JsonUtil.toJson(map);
    }

    private static String encodeBase64File(InputStream file) {
        return Base64.getEncoder().encodeToString(CryptoUtils.readFile(file));
    }

    private static byte[] readFile(InputStream file) {
        try {
            return IOUtils.toByteArray((InputStream)file);
        }
        catch (IOException e) {
            throw new JunoApiException("Error reading the file contents", e);
        }
    }

    private static String generateJweToken(PublicKey publicKey, String content) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setAlgorithmHeaderValue("RSA-OAEP-256");
            jwe.setEncryptionMethodHeaderParameter("A256GCM");
            jwe.enableDefaultCompression();
            jwe.setKey((Key)publicKey);
            jwe.setPlaintext(content);
            return jwe.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new JunoApiException("Error generating JWE token", e);
        }
    }

    private static void compressJwe(OutputStream output, String jweToken) {
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(output);
            gzip.write(jweToken.getBytes(StandardCharsets.UTF_8));
            gzip.close();
        }
        catch (IOException e) {
            throw new JunoApiException("Error compressing JWE", e);
        }
    }

    public static interface Crypto {
        public static final String CRYPTO_METHOD = "RSA";
        public static final String MD_NAME = "SHA-256";
        public static final String MG_NAME = "MGF1";
        public static final String CRYPTO_TRANSFORM = "RSA/ECB/OAEPPadding";
    }
}

