package com.thanlinardos.spring_enterprise_library.error.utils;

import com.thanlinardos.spring_enterprise_library.error.errorcodes.ErrorCode;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * A util with methods helpful for handling exceptions and {@link ErrorCode}s.
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ExceptionUtils {

    /**
     * Gets the stack trace from a Throwable as a String, including suppressed and cause exceptions.
     *
     * <p>
     * The result of this method vary by JDK version as this method
     * uses {@link Throwable#printStackTrace(java.io.PrintWriter)}.
     * </p>
     *
     * @param throwable the {@link Throwable} to be examined, may be null
     * @return the stack trace as generated by the exception's
     * {@code printStackTrace(PrintWriter)} method, or an empty String if {@code null} input.
     */
    public static String getStackTrace(final Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        final StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw, true));
        return sw.toString();
    }
}
