/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.math;

import com.thanlinardos.spring_enterprise_library.annotations.CoreTest;
import com.thanlinardos.spring_enterprise_library.math.UInt;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

@CoreTest
class UIntTest {
    UIntTest() {
    }

    public static Stream<Arguments> rangeUIntFactory() {
        return LongStream.range(2L, 100L).mapToObj(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @NullSource
    @ValueSource(longs={0L, 1L, -1L, -100L, -4294967295L, 0L, 0xFFFFFFFFL, 131435L})
    @MethodSource(value={"rangeUIntFactory"})
    void testUInt_zero(Long value) {
        if (value == null) {
            Assertions.assertThrows(NullPointerException.class, () -> this.getUInt(null));
        } else if (value < 0L || value > 0xFFFFFFFFL) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.getUInt(value));
        } else {
            UInt uInt = this.getUInt(value);
            Assertions.assertEquals((Long)value, (long)uInt.longValue());
        }
    }

    private UInt getUInt(Long value) {
        return new UInt(value.longValue());
    }
}

