/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.model;

import com.thanlinardos.spring_enterprise_library.annotations.SpringTest;
import com.thanlinardos.spring_enterprise_library.time.model.Interval;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@SpringTest
class IntervalTest {
    private static final Interval YEAR_2000 = Interval.forIsoDates((String)"2000-01-01", (String)"2000-12-31");
    private static final Interval INTERVAL_2000_01 = Interval.forIsoDates((String)"2000-01-01", (String)"2000-01-31");
    private static final Interval OPEN_END = new Interval(LocalDate.parse("2000-05-01"), null);
    private static final Interval JAN_MAY_2000 = Interval.forIsoDates((String)"2000-01-01", (String)"2000-05-31");
    private static final Interval JUN_JUL_2000 = Interval.forIsoDates((String)"2000-06-01", (String)"2000-07-31");
    private static final Interval FEB_OCT_2000 = Interval.forIsoDates((String)"2000-02-01", (String)"2000-10-31");
    private static final Interval APR_2024 = Interval.forIsoDates((String)"2024-03-01", (String)"2024-03-31");
    private static final Interval JUN_2024 = Interval.forIsoDates((String)"2024-06-01", (String)"2024-06-30");
    private static final Interval NOV_2024 = Interval.forIsoDates((String)"2024-11-01", (String)"2024-11-30");
    private static final Interval JAN_NOV_2024 = Interval.forIsoDates((String)"2024-01-01", (String)"2024-11-30");
    private static final Interval JAN_2024 = Interval.forIsoDates((String)"2024-01-01", (String)"2024-01-31");
    private static final Interval APR_MAY_2024 = Interval.forIsoDates((String)"2024-04-01", (String)"2024-05-31");
    private static final Interval JUL_OCT_2024 = Interval.forIsoDates((String)"2024-07-01", (String)"2024-10-31");
    private static final Interval FEB_2024 = Interval.forIsoDates((String)"2024-02-01", (String)"2024-02-29");
    private static final Interval NOV_2000 = Interval.forIsoDates((String)"2000-11-01", (String)"2000-11-30");
    private static final Interval JAN_NOV_2000 = Interval.forIsoDates((String)"2000-01-01", (String)"2000-11-30");
    private static final Interval JAN_OCT_2000 = Interval.forIsoDates((String)"2000-01-01", (String)"2000-10-31");
    private static final Interval YEAR_2001 = Interval.forIsoDates((String)"2001-01-01", (String)"2001-12-31");
    private static final Interval YEARS_2000_2001 = Interval.forIsoDates((String)"2000-01-01", (String)"2001-12-31");
    private static final Interval YEAR_3333 = Interval.forIsoDates((String)"3333-01-01", (String)"3333-12-31");
    private static final Interval MAY_2000 = Interval.forIsoDates((String)"2000-05-01", (String)"2000-05-31");
    private static final Interval APR_MAY_2000 = Interval.forIsoDates((String)"2000-04-01", (String)"2000-05-31");

    IntervalTest() {
    }

    public static Stream<Arguments> splitFactory() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Empty list", Collections.emptyList(), Collections.emptyList()}), Arguments.of((Object[])new Object[]{"One interval", List.of(YEAR_2000), List.of(YEAR_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 partially overlaps interval 2", List.of(JAN_MAY_2000, Interval.forIsoDates((String)"2000-03-31", (String)"2000-07-31")), List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-03-30"), Interval.forIsoDates((String)"2000-03-31", (String)"2000-05-31"), JUN_JUL_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 neighbors interval 2", List.of(JAN_MAY_2000, JUN_JUL_2000), List.of(JAN_MAY_2000, JUN_JUL_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 has gap to interval 2", List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-03-31"), JUN_JUL_2000), List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-03-31"), JUN_JUL_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 contains interval 2", List.of(JAN_MAY_2000, Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-03-14"), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), APR_MAY_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 ends at one-day interval 2", List.of(JAN_MAY_2000, Interval.forIsoDates((String)"2000-05-31", (String)"2000-05-31")), List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-05-30"), Interval.forIsoDates((String)"2000-05-31", (String)"2000-05-31"))}), Arguments.of((Object[])new Object[]{"Ensemble scenario", List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-01-05"), Interval.forIsoDates((String)"2000-01-03", (String)"2000-01-07"), Interval.forIsoDates((String)"2000-01-06", (String)"2000-01-08"), Interval.forIsoDates((String)"2000-01-08", (String)"2000-01-08"), Interval.forIsoDates((String)"2000-01-08", (String)"2000-01-10"), Interval.forIsoDates((String)"2000-01-10", (String)"2000-01-12"), Interval.forIsoDates((String)"2000-01-15", (String)"2000-01-19"), Interval.forIsoDates((String)"2000-01-16", (String)"2000-01-18")), List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-01-02"), Interval.forIsoDates((String)"2000-01-03", (String)"2000-01-05"), Interval.forIsoDates((String)"2000-01-06", (String)"2000-01-07"), Interval.forIsoDates((String)"2000-01-08", (String)"2000-01-08"), Interval.forIsoDates((String)"2000-01-09", (String)"2000-01-09"), Interval.forIsoDates((String)"2000-01-10", (String)"2000-01-10"), Interval.forIsoDates((String)"2000-01-11", (String)"2000-01-12"), Interval.forIsoDates((String)"2000-01-15", (String)"2000-01-15"), Interval.forIsoDates((String)"2000-01-16", (String)"2000-01-18"), Interval.forIsoDates((String)"2000-01-19", (String)"2000-01-19"))}), Arguments.of((Object[])new Object[]{"Start inside and end inside", List.of(JAN_OCT_2000, JAN_NOV_2000, FEB_OCT_2000), List.of(INTERVAL_2000_01, FEB_OCT_2000, NOV_2000)}), Arguments.of((Object[])new Object[]{"Year interval + overlapping month intervals", List.of(FEB_2024, APR_2024, JUN_2024, NOV_2024, JAN_NOV_2024), List.of(JAN_2024, FEB_2024, APR_2024, APR_MAY_2024, JUN_2024, JUL_OCT_2024, NOV_2024)}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) partially overlaps interval 2 (null end)", List.of(Interval.forIsoDates(null, (String)"2000-05-31"), Interval.forIsoDates((String)"2000-03-31", null)), List.of(Interval.forIsoDates(null, (String)"2000-03-30"), Interval.forIsoDates((String)"2000-03-31", (String)"2000-05-31"), Interval.forIsoDates((String)"2000-06-01", null))}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) neighbors interval 2 (null end)", List.of(Interval.forIsoDates(null, (String)"2000-05-31"), Interval.forIsoDates((String)"2000-06-01", null)), List.of(Interval.forIsoDates(null, (String)"2000-05-31"), Interval.forIsoDates((String)"2000-06-01", null))}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) has gap to interval 2 (null end)", List.of(Interval.forIsoDates(null, (String)"2000-03-31"), Interval.forIsoDates((String)"2000-06-01", null)), List.of(Interval.forIsoDates(null, (String)"2000-03-31"), Interval.forIsoDates((String)"2000-06-01", null))}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) contains interval 2", List.of(Interval.forIsoDates(null, (String)"2000-05-31"), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(Interval.forIsoDates(null, (String)"2000-03-14"), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), APR_MAY_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 (null end) contains interval 2", List.of(Interval.forIsoDates((String)"2000-01-01", null), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2000-03-14"), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), Interval.forIsoDates((String)"2000-04-01", null))}), Arguments.of((Object[])new Object[]{"Interval 1 (null to null) contains interval 2", List.of(Interval.forIsoDates(null, null), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(Interval.forIsoDates(null, (String)"2000-03-14"), Interval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), Interval.forIsoDates((String)"2000-04-01", null))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"splitFactory"})
    void split(String description, Collection<Interval> input, Collection<Interval> expected) {
        List actual = Interval.split(input);
        Assertions.assertEquals(expected, (Object)actual);
    }

    private static Stream<Arguments> normalizeParams() {
        return Stream.of(Arguments.argumentSet((String)"Empty list", (Object[])new Object[]{Collections.emptyList(), true, Collections.emptyList()}), Arguments.argumentSet((String)"One interval", (Object[])new Object[]{List.of(OPEN_END), true, List.of(OPEN_END)}), Arguments.argumentSet((String)"Same interval", (Object[])new Object[]{List.of(YEAR_2000, YEAR_2000), true, List.of(YEAR_2000)}), Arguments.argumentSet((String)"Two intervals, no overlap", (Object[])new Object[]{List.of(YEAR_2000, YEAR_3333), true, List.of(YEAR_2000, YEAR_3333)}), Arguments.argumentSet((String)"Two intervals, overlap", (Object[])new Object[]{List.of(YEAR_2000, Interval.forIsoDates((String)"2000-05-01", (String)"2001-05-31")), true, List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2001-05-31"))}), Arguments.argumentSet((String)"Two intervals, fully contain", (Object[])new Object[]{List.of(YEAR_2000, MAY_2000), true, List.of(YEAR_2000)}), Arguments.argumentSet((String)"Two intervals, reverse overlap", (Object[])new Object[]{List.of(Interval.forIsoDates((String)"2000-05-01", (String)"2001-05-31"), YEAR_2000), true, List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2001-05-31"))}), Arguments.argumentSet((String)"Two intervals, neighboring", (Object[])new Object[]{List.of(YEAR_2000, YEAR_2001), true, List.of(YEARS_2000_2001)}), Arguments.argumentSet((String)"Two intervals, neighboring (don't merge adjacent intervals)", (Object[])new Object[]{List.of(YEAR_2000, YEAR_2001), false, List.of(YEAR_2000, YEAR_2001)}), Arguments.argumentSet((String)"Two intervals, overlap (don't merge adjacent intervals)", (Object[])new Object[]{List.of(YEAR_2000, Interval.forIsoDates((String)"2000-05-01", (String)"2001-05-31")), false, List.of(Interval.forIsoDates((String)"2000-01-01", (String)"2001-05-31"))}));
    }

    @ParameterizedTest
    @MethodSource(value={"normalizeParams"})
    void normalize(List<Interval> intervals, boolean mergeAdjacentIntervals, List<Interval> expected) {
        Assertions.assertEquals(expected, (Object)Interval.normalize(intervals, (boolean)mergeAdjacentIntervals));
    }
}

