/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.model;

import com.thanlinardos.spring_enterprise_library.annotations.SpringTest;
import com.thanlinardos.spring_enterprise_library.time.model.TimeInterval;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@SpringTest
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class TimeIntervalTest {
    private static final TimeInterval YEAR_2000 = TimeInterval.forIsoDatesMilli((String)"2000-01-01", (String)"2000-12-31");
    private static final TimeInterval INTERVAL_200001 = TimeInterval.forIsoDatesMilli((String)"2000-01-01", (String)"2000-01-31");
    private static final TimeInterval OPEN_END = TimeInterval.forIsoDateMilliToNull((String)"2000-05-01");
    private static final TimeInterval JAN_MAY_2000 = TimeInterval.forIsoDatesMilli((String)"2000-01-01", (String)"2000-05-31");
    private static final TimeInterval JUN_JUL_2000 = TimeInterval.forIsoDatesMilli((String)"2000-06-01", (String)"2000-07-31");
    private static final TimeInterval FEB_OCT_2000 = TimeInterval.forIsoDatesMilli((String)"2000-02-01", (String)"2000-10-31");
    private static final TimeInterval APR_2024 = TimeInterval.forIsoDatesMilli((String)"2024-03-01", (String)"2024-03-31");
    private static final TimeInterval JUN_2024 = TimeInterval.forIsoDatesMilli((String)"2024-06-01", (String)"2024-06-30");
    private static final TimeInterval NOV_2024 = TimeInterval.forIsoDatesMilli((String)"2024-11-01", (String)"2024-11-30");
    private static final TimeInterval JAN_NOV_2024 = TimeInterval.forIsoDatesMilli((String)"2024-01-01", (String)"2024-11-30");
    private static final TimeInterval JAN_2024 = TimeInterval.forIsoDatesMilli((String)"2024-01-01", (String)"2024-01-31");
    private static final TimeInterval APR_MAY_2024 = TimeInterval.forIsoDatesMilli((String)"2024-04-01", (String)"2024-05-31");
    private static final TimeInterval JUL_OCT_2024 = TimeInterval.forIsoDatesMilli((String)"2024-07-01", (String)"2024-10-31");
    private static final TimeInterval FEB_2024 = TimeInterval.forIsoDatesMilli((String)"2024-02-01", (String)"2024-02-29");
    private static final TimeInterval NOV_2000 = TimeInterval.forIsoDatesMilli((String)"2000-11-01", (String)"2000-11-30");
    private static final TimeInterval JAN_NOV_2000 = TimeInterval.forIsoDatesMilli((String)"2000-01-01", (String)"2000-11-30");
    private static final TimeInterval JAN_OCT_2000 = TimeInterval.forIsoDatesMilli((String)"2000-01-01", (String)"2000-10-31");
    private static final TimeInterval YEAR_2001 = TimeInterval.forIsoDatesMilli((String)"2001-01-01", (String)"2001-12-31");
    private static final TimeInterval YEARS_2000_2001 = TimeInterval.forIsoDatesMilli((String)"2000-01-01", (String)"2001-12-31");
    private static final TimeInterval YEAR_3333 = TimeInterval.forIsoDatesMilli((String)"3333-01-01", (String)"3333-12-31");
    private static final TimeInterval MAY_2000 = TimeInterval.forIsoDatesMilli((String)"2000-05-01", (String)"2000-05-31");
    private static final TimeInterval APR_MAY_2000 = TimeInterval.forIsoDatesMilli((String)"2000-04-01", (String)"2000-05-31");
    private static final TimeInterval JUN_2000_TO_EOW = TimeInterval.forIsoDateToNull((String)"2000-06-01");

    TimeIntervalTest() {
    }

    public static Stream<Arguments> splitFactory() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Empty list", Collections.emptyList(), Collections.emptyList()}), Arguments.of((Object[])new Object[]{"One interval", List.of(YEAR_2000), List.of(YEAR_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 partially overlaps interval 2", List.of(JAN_MAY_2000, TimeInterval.forIsoDates((String)"2000-03-31", (String)"2000-07-31")), List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-03-30"), TimeInterval.forIsoDates((String)"2000-03-31", (String)"2000-05-31"), JUN_JUL_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 neighbors interval 2", List.of(JAN_MAY_2000, JUN_JUL_2000), List.of(JAN_MAY_2000, JUN_JUL_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 has gap to interval 2", List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-03-31"), JUN_JUL_2000), List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-03-31"), JUN_JUL_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 contains interval 2", List.of(JAN_MAY_2000, TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-03-14"), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), APR_MAY_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 ends at one-day interval 2", List.of(JAN_MAY_2000, TimeInterval.forIsoDates((String)"2000-05-31", (String)"2000-05-31")), List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-05-30"), TimeInterval.forIsoDates((String)"2000-05-31", (String)"2000-05-31"))}), Arguments.of((Object[])new Object[]{"Ensemble scenario", List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-01-05"), TimeInterval.forIsoDates((String)"2000-01-03", (String)"2000-01-07"), TimeInterval.forIsoDates((String)"2000-01-06", (String)"2000-01-08"), TimeInterval.forIsoDates((String)"2000-01-08", (String)"2000-01-08"), TimeInterval.forIsoDates((String)"2000-01-08", (String)"2000-01-10"), TimeInterval.forIsoDates((String)"2000-01-10", (String)"2000-01-12"), TimeInterval.forIsoDates((String)"2000-01-15", (String)"2000-01-19"), TimeInterval.forIsoDates((String)"2000-01-16", (String)"2000-01-18")), List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-01-02"), TimeInterval.forIsoDates((String)"2000-01-03", (String)"2000-01-05"), TimeInterval.forIsoDates((String)"2000-01-06", (String)"2000-01-07"), TimeInterval.forIsoDates((String)"2000-01-08", (String)"2000-01-08"), TimeInterval.forIsoDates((String)"2000-01-09", (String)"2000-01-09"), TimeInterval.forIsoDates((String)"2000-01-10", (String)"2000-01-10"), TimeInterval.forIsoDates((String)"2000-01-11", (String)"2000-01-12"), TimeInterval.forIsoDates((String)"2000-01-15", (String)"2000-01-15"), TimeInterval.forIsoDates((String)"2000-01-16", (String)"2000-01-18"), TimeInterval.forIsoDates((String)"2000-01-19", (String)"2000-01-19"))}), Arguments.of((Object[])new Object[]{"Start inside and end inside", List.of(JAN_OCT_2000, JAN_NOV_2000, FEB_OCT_2000), List.of(INTERVAL_200001, FEB_OCT_2000, NOV_2000)}), Arguments.of((Object[])new Object[]{"Year interval + overlapping month intervals", List.of(FEB_2024, APR_2024, JUN_2024, NOV_2024, JAN_NOV_2024), List.of(JAN_2024, FEB_2024, APR_2024, APR_MAY_2024, JUN_2024, JUL_OCT_2024, NOV_2024)}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) partially overlaps interval 2 (null end)", List.of(TimeInterval.forIsoDates(null, (String)"2000-05-31"), TimeInterval.forIsoDateToNull((String)"2000-03-31")), List.of(TimeInterval.forIsoDates(null, (String)"2000-03-30"), TimeInterval.forIsoDates((String)"2000-03-31", (String)"2000-05-31"), TimeInterval.forIsoDates((String)"2000-06-01", null))}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) neighbors interval 2 (null end)", List.of(TimeInterval.forIsoDates(null, (String)"2000-05-31"), JUN_2000_TO_EOW), List.of(TimeInterval.forIsoDates(null, (String)"2000-05-31"), JUN_2000_TO_EOW)}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) has gap to interval 2 (null end)", List.of(TimeInterval.forIsoDates(null, (String)"2000-03-31"), JUN_2000_TO_EOW), List.of(TimeInterval.forIsoDates(null, (String)"2000-03-31"), JUN_2000_TO_EOW)}), Arguments.of((Object[])new Object[]{"Interval 1 (null start) contains interval 2", List.of(TimeInterval.forIsoDates(null, (String)"2000-05-31"), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(TimeInterval.forIsoDates(null, (String)"2000-03-14"), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), APR_MAY_2000)}), Arguments.of((Object[])new Object[]{"Interval 1 (null end) contains interval 2", List.of(TimeInterval.forIsoDates((String)"2000-01-01", null), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2000-03-14"), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), TimeInterval.forIsoDates((String)"2000-04-01", null))}), Arguments.of((Object[])new Object[]{"Interval 1 (null to null) contains interval 2", List.of(TimeInterval.forIsoDates(null, null), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31")), List.of(TimeInterval.forIsoDates(null, (String)"2000-03-14"), TimeInterval.forIsoDates((String)"2000-03-15", (String)"2000-03-31"), TimeInterval.forIsoDates((String)"2000-04-01", null))}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"splitFactory"})
    void split(String description, Collection<TimeInterval> input, Collection<TimeInterval> expected) {
        List actual = TimeInterval.split(input);
        Assertions.assertEquals(expected, (Object)actual);
    }

    private static Stream<Arguments> normalizeParams() {
        return Stream.of(Arguments.argumentSet((String)"Empty list", (Object[])new Object[]{Collections.emptyList(), true, Collections.emptyList()}), Arguments.argumentSet((String)"One interval", (Object[])new Object[]{List.of(OPEN_END), true, List.of(OPEN_END)}), Arguments.argumentSet((String)"Same interval", (Object[])new Object[]{List.of(YEAR_2000, YEAR_2000), true, List.of(YEAR_2000)}), Arguments.argumentSet((String)"Two intervals, no overlap", (Object[])new Object[]{List.of(YEAR_2000, YEAR_3333), true, List.of(YEAR_2000, YEAR_3333)}), Arguments.argumentSet((String)"Two intervals, overlap", (Object[])new Object[]{List.of(YEAR_2000, TimeInterval.forIsoDates((String)"2000-05-01", (String)"2001-05-31")), true, List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2001-05-31"))}), Arguments.argumentSet((String)"Two intervals, fully contain", (Object[])new Object[]{List.of(YEAR_2000, MAY_2000), true, List.of(YEAR_2000)}), Arguments.argumentSet((String)"Two intervals, reverse overlap", (Object[])new Object[]{List.of(TimeInterval.forIsoDates((String)"2000-05-01", (String)"2001-05-31"), YEAR_2000), true, List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2001-05-31"))}), Arguments.argumentSet((String)"Two intervals, neighboring", (Object[])new Object[]{List.of(YEAR_2000, YEAR_2001), true, List.of(YEARS_2000_2001)}), Arguments.argumentSet((String)"Two intervals, neighboring (don't merge adjacent intervals)", (Object[])new Object[]{List.of(YEAR_2000, YEAR_2001), false, List.of(YEAR_2000, YEAR_2001)}), Arguments.argumentSet((String)"Two intervals, overlap (don't merge adjacent intervals)", (Object[])new Object[]{List.of(YEAR_2000, TimeInterval.forIsoDates((String)"2000-05-01", (String)"2001-05-31")), false, List.of(TimeInterval.forIsoDates((String)"2000-01-01", (String)"2001-05-31"))}));
    }

    @ParameterizedTest
    @MethodSource(value={"normalizeParams"})
    void normalize(List<TimeInterval> intervals, boolean mergeAdjacentIntervals, List<TimeInterval> expected) {
        Assertions.assertEquals(expected, (Object)TimeInterval.normalize(intervals, (boolean)mergeAdjacentIntervals));
    }
}

