/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.utils;

import com.thanlinardos.spring_enterprise_library.annotations.CoreTest;
import com.thanlinardos.spring_enterprise_library.objects.utils.ObjectUtils;
import java.time.LocalDate;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@CoreTest
class ObjectUtilsTest {
    ObjectUtilsTest() {
    }

    private static Stream<Arguments> isAllObjectsNotNullAndEqualsParams() {
        return Stream.of(Arguments.argumentSet((String)"2 nulls", (Object[])new Object[]{false, null, null, null}), Arguments.argumentSet((String)"1 null, 1 not null", (Object[])new Object[]{false, null, new Object[]{LocalDate.MAX}}), Arguments.argumentSet((String)"1 not null, 1 null", (Object[])new Object[]{false, LocalDate.MAX, new Object[]{null}}), Arguments.argumentSet((String)"1 not null, 1 not equal", (Object[])new Object[]{false, LocalDate.MAX, new Object[]{LocalDate.MIN}}), Arguments.argumentSet((String)"1 not null, 1 equal", (Object[])new Object[]{true, LocalDate.MAX, new Object[]{LocalDate.MAX}}), Arguments.argumentSet((String)"1 not null, 2 equal", (Object[])new Object[]{true, LocalDate.MAX, new Object[]{LocalDate.MAX, LocalDate.MAX}}), Arguments.argumentSet((String)"1 not null, 2 not equal", (Object[])new Object[]{false, LocalDate.MAX, new Object[]{LocalDate.MIN, LocalDate.of(2024, 1, 1)}}), Arguments.argumentSet((String)"1 not null, 1 equal, 1 not equal", (Object[])new Object[]{false, LocalDate.MAX, new Object[]{LocalDate.MAX, LocalDate.MIN}}));
    }

    @ParameterizedTest
    @MethodSource(value={"isAllObjectsNotNullAndEqualsParams"})
    void isAllObjectsNotNullAndEquals(boolean expected, Object object, Object ... others) {
        boolean actual = ObjectUtils.isAllObjectsNotNullAndEquals((Object)object, (Object[])others);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

