/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.https;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.HttpURLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.springframework.http.client.SimpleClientHttpRequestFactory;

public class SecureHttpRequestFactory
extends SimpleClientHttpRequestFactory {
    private final SSLContext sslContext;

    public SecureHttpRequestFactory(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected void prepareConnection(@Nonnull HttpURLConnection connection, @Nonnull String httpMethod) throws IOException {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
            httpsURLConnection.setSSLSocketFactory(this.sslContext.getSocketFactory());
            httpsURLConnection.setHostnameVerifier((hostname, session) -> false);
        }
        super.prepareConnection(connection, httpMethod);
    }
}

