/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.objects.utils;

import com.thanlinardos.spring_enterprise_library.error.errorcodes.ErrorCode;
import com.thanlinardos.spring_enterprise_library.error.exceptions.CoreException;
import com.thanlinardos.spring_enterprise_library.objects.utils.PredicateUtils;
import com.thanlinardos.spring_enterprise_library.objects.utils.StreamUtils;
import jakarta.annotation.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;

public class CollectionUtils {
    public static <T> boolean isEmpty(@Nullable Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(@Nullable Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T, U extends Collection<T>> U requireNotEmpty(@Nullable U collection) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new CoreException(ErrorCode.ILLEGAL_ARGUMENT, "Collection argument is null or empty");
        }
        return collection;
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<T> predicate) {
        return StreamUtils.ofNullable(collection).anyMatch(predicate);
    }

    @SafeVarargs
    public static <T> boolean containsAnyOf(Collection<T> collection, T ... values) {
        return StreamUtils.ofNullable(values).anyMatch(collection::contains);
    }

    public static <T> boolean contains(T[] collection, Predicate<T> predicate) {
        return StreamUtils.ofNullable(collection).anyMatch(predicate);
    }

    public static <A, B> boolean containsAnyNull(Collection<A> collection, Function<A, B> getter) {
        return collection.stream().map(getter).anyMatch(Objects::isNull);
    }

    public static <T> boolean notContains(Collection<T> collection, Predicate<T> predicate) {
        return !CollectionUtils.contains(collection, predicate);
    }

    @SafeVarargs
    public static <T> boolean isIn(T target, T ... values) {
        if (values == null) {
            return Predicate.isEqual(target).test(null);
        }
        return Stream.of(values).anyMatch(Predicate.isEqual(target));
    }

    public static <T> boolean isIn(@Nullable T target, @Nullable Collection<T> values) {
        if (values == null) {
            return Predicate.isEqual(target).test(null);
        }
        return values.stream().anyMatch(Predicate.isEqual(target));
    }

    @SafeVarargs
    public static <T> boolean isNotIn(T target, T ... values) {
        return !CollectionUtils.isIn(target, values);
    }

    public static <T> boolean isNotIn(T target, Collection<T> values) {
        return !CollectionUtils.isIn(target, values);
    }

    @SafeVarargs
    public static <T> List<T> combineToList(Collection<T> ... collections) {
        return Stream.of(collections).flatMap(Collection::stream).toList();
    }

    public static <T> List<T> combineToList(List<T> first, List<T> second) {
        return ListUtils.union(first, second);
    }

    @SafeVarargs
    public static <T> Set<T> combineToSet(Collection<T> ... collections) {
        return Stream.of(collections).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static <T> Set<T> combineToSet(Set<T> first, Set<T> second) {
        return SetUtils.union(first, second);
    }

    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> copyList = new ArrayList<T>(list);
        Collections.reverse(copyList);
        return copyList;
    }

    public static <T, S, R> List<R> zipWith(BiFunction<T, S, R> function, List<T> elementList1, List<S> elementList2) {
        if (CollectionUtils.isEmpty(elementList1) || CollectionUtils.isEmpty(elementList2)) {
            throw ErrorCode.EMPTY_LIST.createCoreException("A list was null or empty for zipping, list 1 = {0}, list 2 = {1}", new Object[]{Objects.toString(elementList1), Objects.toString(elementList2)});
        }
        if (elementList1.size() != elementList2.size()) {
            throw ErrorCode.LIST_NOT_SAME_SIZE.createCoreException("The two list did not have the same size for zipping, list 1 = {0}, list 2 = {1}", new Object[]{Integer.toString(elementList1.size()), Integer.toString(elementList2.size())});
        }
        return IntStream.range(0, elementList1.size()).mapToObj(i -> function.apply(elementList1.get(i), elementList2.get(i))).toList();
    }

    public static <T, R> List<R> merge(BiPredicate<T, T> shouldMerge, BinaryOperator<R> merge, Function<T, R> convert, List<T> elementList) {
        if (CollectionUtils.isEmpty(elementList)) {
            return new ArrayList();
        }
        ArrayDeque<R> stack = new ArrayDeque<R>();
        stack.add(convert.apply(elementList.getFirst()));
        for (int i = 1; i < elementList.size(); ++i) {
            T current = elementList.get(i);
            T previous = elementList.get(i - 1);
            R convertedCurrent = convert.apply(current);
            if (shouldMerge.test(current, previous)) {
                stack.push(merge.apply(convertedCurrent, stack.pop()));
                continue;
            }
            stack.push(convertedCurrent);
        }
        return new ArrayList(stack);
    }

    public static <T, R> List<R> sortAndMerge(BiPredicate<T, T> shouldMerge, BinaryOperator<R> merge, Function<T, R> convert, Comparator<T> listComparator, List<T> elementList) {
        List sortedList = elementList.stream().sorted(listComparator).toList();
        return CollectionUtils.merge(shouldMerge, merge, convert, sortedList);
    }

    public static <T, S> boolean consideredEqual(BiPredicate<T, S> predicate, List<T> elementList1, List<S> elementList2) {
        return CollectionUtils.isTriviallyEqualOrUnequal(elementList1, elementList2).orElseGet(() -> CollectionUtils.checkPairwiseEquality(predicate, elementList1, elementList2));
    }

    private static <A, B> Optional<Boolean> isTriviallyEqualOrUnequal(Collection<A> a, Collection<B> b) {
        boolean aNull = Objects.isNull(a);
        boolean bNull = Objects.isNull(b);
        boolean aEmpty = CollectionUtils.isEmpty(a);
        boolean bEmpty = CollectionUtils.isEmpty(b);
        if (aNull || bNull) {
            return Optional.of(aNull && bNull);
        }
        if (aEmpty || bEmpty) {
            return Optional.of(aEmpty && bEmpty);
        }
        if (a.size() != b.size()) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private static <T, S> boolean checkPairwiseEquality(BiPredicate<T, S> function, List<T> elementList1, List<S> elementList2) {
        return IntStream.range(0, elementList1.size()).allMatch(i -> function.test(elementList1.get(i), elementList2.get(i)));
    }

    public static <B> boolean consideredEqualIgnoringOrder(BiPredicate<B, B> predicate, @Nullable Collection<B> first, @Nullable Collection<B> second) {
        return CollectionUtils.isTriviallyEqualOrUnequal(first, second).orElseGet(() -> CollectionUtils.allMatchAnyOnPredicate(predicate, first, second) && CollectionUtils.allMatchAnyOnPredicate(predicate, second, first));
    }

    private static <B> boolean allMatchAnyOnPredicate(BiPredicate<B, B> predicate, Collection<B> a, Collection<B> b) {
        return StreamUtils.ofNullable(a).allMatch(x -> StreamUtils.ofNullable(b).anyMatch(y -> predicate.test(x, y)));
    }

    public static <T, S> boolean consideredNotEqual(BiPredicate<T, S> predicate, List<T> elementList1, List<S> elementList2) {
        return !CollectionUtils.consideredEqual(predicate, elementList1, elementList2);
    }

    public static <T extends U, U> boolean intersects(Collection<T> a, Collection<U> b) {
        return CollectionUtils.contains(a, b::contains);
    }

    public static <T extends U, U> boolean hasDifferenceBetweenAnyWay(Set<T> a, Set<U> b) {
        if (CollectionUtils.isEmpty(a) && CollectionUtils.isEmpty(b)) {
            return false;
        }
        if (CollectionUtils.isEmpty(a) || CollectionUtils.isEmpty(b)) {
            return true;
        }
        return CollectionUtils.isNotEmpty(SetUtils.disjunction(a, b));
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... elements) {
        if (elements == null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(null);
            return list;
        }
        return Arrays.asList(elements);
    }

    public static <T, R> List<T> filterByMaxValueForField(Collection<T> collection, Function<T, R> extractor, Comparator<R> comparator) {
        Optional<Object> maxValue;
        if (CollectionUtils.isNotEmpty(collection) && (maxValue = collection.stream().filter(Objects::nonNull).map(extractor).filter(Objects::nonNull).max(comparator)).isPresent()) {
            return collection.stream().filter(Objects::nonNull).filter(PredicateUtils.filterBy(Objects::nonNull, extractor)).filter(element -> 0 == comparator.compare(maxValue.get(), extractor.apply(element))).toList();
        }
        return Collections.emptyList();
    }

    public static <T> Collection<T> removeAll(Collection<T> base, Collection<T> filter, BiPredicate<T, T> removeIf) {
        return base.stream().filter(baseElement -> CollectionUtils.notContains(filter, filterElement -> removeIf.test(baseElement, filterElement))).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> Collection<T> retainAll(Collection<T> base, Collection<T> filter, BiPredicate<T, T> retainIf) {
        return base.stream().filter(baseElement -> CollectionUtils.contains(filter, (T filterElement) -> retainIf.test(baseElement, filterElement))).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> Optional<T> findExactlyOneOrNone(Collection<T> entities, Predicate<T> predicate) {
        return CollectionUtils.filterAndCollect(entities, predicate, StreamUtils.findExactlyOneOrNone("Found more than one entity in {0} matching the predicate {1}", StreamUtils.getDebugStringSuppliers(entities, predicate)));
    }

    public static <T> T findExactlyOne(Collection<T> entities, Predicate<T> predicate) {
        return CollectionUtils.filterAndCollect(entities, predicate, StreamUtils.findExactlyOne("Couldn't find an entity in {0} matching the predicate {1}", StreamUtils.getDebugStringSuppliers(entities, predicate)));
    }

    public static <T> List<T> filterByPredicate(Collection<T> entities, Predicate<T> predicate) {
        return CollectionUtils.filterAndCollect(entities, predicate, Collectors.toList());
    }

    private static <T, U> U filterAndCollect(Collection<T> entities, Predicate<T> predicate, Collector<T, ?, U> collector) {
        return entities.stream().filter(predicate).collect(collector);
    }

    public static <T> List<T> emptyListIfNull(@Nullable Collection<T> collection) {
        return StreamUtils.ofNullable(collection).toList();
    }

    public static <T> boolean hasSizeInRange(@Nullable Collection<T> collection, Integer from, Integer to) {
        int size = CollectionUtils.emptyListIfNull(collection).size();
        return size >= from && size <= to;
    }

    public static boolean isNotEmpty(@Nullable Object[] array) {
        return array != null && array.length > 0;
    }

    @Generated
    private CollectionUtils() {
    }
}

