/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.objects.utils;

import com.thanlinardos.spring_enterprise_library.error.errorcodes.ErrorCode;
import com.thanlinardos.spring_enterprise_library.error.exceptions.CoreException;
import com.thanlinardos.spring_enterprise_library.error.utils.ExceptionUtils;
import com.thanlinardos.spring_enterprise_library.model.entity.base.BasicIdJpa;
import com.thanlinardos.spring_enterprise_library.objects.utils.StreamUtils;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class FunctionUtils {
    public static <T> Function<T, Boolean> negateBoolean(Function<T, Boolean> func) {
        return func.andThen(b -> b == false);
    }

    public static <T, O, R> Function<T, R> apply(BiFunction<T, O, R> function, O object) {
        return t -> function.apply(t, object);
    }

    public static <T1, T2, R> Function<T1, R> compose(Function<T1, T2> func1, Function<T2, R> func2) {
        return func1.andThen(func2);
    }

    public static <T1, T2, R> Function<T1, R> composeNullSafe(Function<T1, T2> firstGetter, Function<T2, R> finalGetter) {
        return FunctionUtils.wrapWithNullHandling(firstGetter).andThen(FunctionUtils.wrapWithNullHandling(finalGetter));
    }

    public static <T1, T2, R> Function<T1, Set<R>> composeWithSetNullSafe(Function<T1, Set<T2>> firstGetter, Function<T2, R> finalGetter) {
        return FunctionUtils.wrapWithNullHandling(firstGetter).andThen(FunctionUtils.extractWithNullHandling(finalGetter));
    }

    public static <T1, T2, R> Function<T1, Set<R>> composeAllNullSafe(Function<T1, Set<T2>> firstGetter, Function<T2, Set<R>> finalGetter) {
        return FunctionUtils.wrapWithNullHandling(firstGetter).andThen(FunctionUtils.extractSetWithNullHandling(finalGetter));
    }

    public static <T1, T2, T3, R> Function<T1, R> composeNullSafe(Function<T1, T2> firstGetter, Function<T2, T3> secondGetter, Function<T3, R> finalGetter) {
        return FunctionUtils.wrapWithNullHandling(firstGetter).andThen(FunctionUtils.wrapWithNullHandling(secondGetter)).andThen(FunctionUtils.wrapWithNullHandling(finalGetter));
    }

    private static <T, R> Function<T, R> wrapWithNullHandling(Function<T, R> function) {
        return t -> Optional.ofNullable(t).map(function).orElse(null);
    }

    private static <T, R> Function<Set<T>, Set<R>> extractWithNullHandling(Function<T, R> function) {
        return t -> StreamUtils.ofNullable(t).map(function).collect(Collectors.toSet());
    }

    private static <T, R> Function<Set<T>, Set<R>> extractSetWithNullHandling(Function<T, Set<R>> function) {
        return t -> StreamUtils.ofNullable(t).map(function).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static <T, O, S> Consumer<T> chainFromOther(@Nullable O other, Function<O, S> func, BiConsumer<S, T> consumer) {
        return t -> Optional.ofNullable(other).map(func).ifPresent(s -> consumer.accept(s, t));
    }

    public static <T, O, S> Consumer<T> chainAllFromOther(@Nullable Collection<O> others, Function<O, S> func, BiConsumer<S, T> consumer) {
        return t -> StreamUtils.ofNullable(others).map(func).filter(Objects::nonNull).forEach(s -> consumer.accept(s, t));
    }

    public static <T, O, S> Consumer<T> chainFromSelf(@Nullable O other, Function<T, S> func, BiConsumer<S, O> consumer) {
        return t -> Optional.ofNullable(other).ifPresent(c -> consumer.accept(func.apply(t), c));
    }

    public static <T, O, S> Consumer<T> chainAllFromSelf(@Nullable Collection<O> others, Function<T, S> func, BiConsumer<S, O> consumer) {
        return t -> StreamUtils.ofNullable(others).filter(Objects::nonNull).forEach(c -> consumer.accept(func.apply(t), c));
    }

    public static <T, R> Function<T, Stream<R>> stream(Function<T, Collection<R>> function) {
        return function.andThen(Collection::stream);
    }

    public static <T, R> Function<T, Stream<R>> streamOptional(Function<T, Optional<R>> function) {
        return function.andThen(Optional::stream);
    }

    public static <U extends BasicIdJpa, R> R rethrowWithEntityId(U entity, Function<U, R> function) {
        try {
            return function.apply(entity);
        }
        catch (Exception e) {
            ErrorCode errorCode = FunctionUtils.getCoreExceptionErrorCodeOrUnexpectedSystemError(e);
            throw new CoreException(errorCode, String.format("Exception occurred applying function to entity (class=%s, id=%s): %s", entity.getClass().getName(), entity.getId(), ExceptionUtils.getStackTrace(e)));
        }
    }

    public static ErrorCode getCoreExceptionErrorCodeOrUnexpectedSystemError(Exception e) {
        return Optional.of(e).filter(CoreException.class::isInstance).map(CoreException.class::cast).map(CoreException::getErrorCode).orElse(ErrorCode.UNEXPECTED_ERROR);
    }

    @Generated
    private FunctionUtils() {
    }
}

