/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.objects.utils;

import com.thanlinardos.spring_enterprise_library.model.api.WithId;
import com.thanlinardos.spring_enterprise_library.model.entity.base.BasicIdJpa;
import com.thanlinardos.spring_enterprise_library.objects.utils.CollectionUtils;
import com.thanlinardos.spring_enterprise_library.objects.utils.FunctionUtils;
import com.thanlinardos.spring_enterprise_library.objects.utils.PredicateUtils;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ObjectUtils {
    public static boolean isAnyObjectNull(Object object, Object ... objects) {
        if (object == null) {
            return true;
        }
        for (Object item : objects) {
            if (item != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyObjectNotNull(Object object, Object ... objects) {
        return !ObjectUtils.isAllObjectsNull(object, objects);
    }

    public static boolean isAllObjectsNull(Object object, Object ... objects) {
        if (object != null) {
            return false;
        }
        for (Object o : objects) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllObjectsNotNull(Object object, Object ... objects) {
        return !ObjectUtils.isAnyObjectNull(object, objects);
    }

    public static boolean isAllObjectsEquals(Object object, Object ... objects) {
        for (Object o : objects) {
            if (o == object) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllObjectsNotNullAndEquals(Object object, Object ... objects) {
        return ObjectUtils.isAllObjectsNotNull(object, objects) && ObjectUtils.isAllObjectsEquals(object, objects);
    }

    @SafeVarargs
    public static boolean evaluateAllTrue(Supplier<Boolean> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).noneMatch(PredicateUtils.negate(Boolean.TRUE::equals));
    }

    @SafeVarargs
    public static boolean evaluateAnyTrue(Supplier<Boolean> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).anyMatch(Boolean.TRUE::equals);
    }

    @SafeVarargs
    public static <T> Optional<T> getFirstNonNull(Supplier<T> ... suppliers) {
        return Stream.of(suppliers).map(Supplier::get).filter(Objects::nonNull).findFirst();
    }

    @SafeVarargs
    public static <T> Optional<T> getFirstPresent(Supplier<Optional<T>> ... suppliers) {
        return Stream.of(suppliers).flatMap(FunctionUtils.streamOptional(Supplier::get)).findFirst();
    }

    public static <T, R> R getOrNull(@Nullable T object, Function<T, R> getter) {
        return Optional.ofNullable(object).map(getter).orElse(null);
    }

    public static Long getIdOrNull(BasicIdJpa entity) {
        return ObjectUtils.getOrNull(entity, BasicIdJpa::getId);
    }

    public static <T extends BasicIdJpa> String getCommaSeparatedListOfIds(Collection<T> entities) {
        return ObjectUtils.collectWithCommaSeparation(entities, BasicIdJpa::getId);
    }

    private static <T> String collectWithCommaSeparation(Collection<T> entities, Function<T, Long> longGetter) {
        return entities.stream().map(longGetter).map(Objects::toString).collect(Collectors.joining(", "));
    }

    public static <T extends BasicIdJpa> Set<Long> getIds(Collection<T> entities) {
        return entities.stream().map(BasicIdJpa::getId).collect(Collectors.toSet());
    }

    public static <T> String getDebugString(Collection<T> entities) {
        String debugString = CollectionUtils.isEmpty(entities) ? "collection is empty" : ObjectUtils.collectStringWithCommaSeparation(entities, ObjectUtils::getDebugString);
        return "[" + debugString + "]";
    }

    public static <T> String getDebugString(@Nullable T entity) {
        if (entity == null) {
            return "{entity is null}";
        }
        if (entity instanceof Collection) {
            return ObjectUtils.getDebugString((Collection)entity);
        }
        if (ObjectUtils.getSimpleName(entity).contains("$$Lambda$")) {
            Method method = entity.getClass().getDeclaredMethods()[0];
            String parameterTypes = ObjectUtils.collectStringWithCommaSeparation(List.of(method.getParameterTypes()), Class::getName);
            return String.format("{lambda=%s, parameterTypes=[%s], returnType=%s}", ObjectUtils.getSimpleName(entity), parameterTypes, method.getReturnType());
        }
        return String.format("{class=%s, id=%s, toString=%s}", ObjectUtils.getSimpleName(entity), ObjectUtils.getId(entity), entity);
    }

    private static <T> String collectStringWithCommaSeparation(Collection<T> entities, Function<T, String> stringGetter) {
        return entities.stream().map(stringGetter).collect(Collectors.joining(", "));
    }

    private static <T> String getSimpleName(T entity) {
        return entity.getClass().getSimpleName();
    }

    private static <T> String getId(T entity) {
        try {
            return Optional.ofNullable(((WithId)entity).getId()).map(Object::toString).orElse("null (from WithId#getId)");
        }
        catch (Exception e) {
            return "null (no WithId#getId method)";
        }
    }

    public static <A, B, C> Optional<C> applyIfBothNotNull(@Nullable A a, @Nullable B b, BiFunction<A, B, C> merger) {
        return ObjectUtils.isAllObjectsNotNull(a, b) ? Optional.of(merger.apply(a, b)) : Optional.empty();
    }

    @Generated
    private ObjectUtils() {
    }
}

