/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.objects.utils;

import com.thanlinardos.spring_enterprise_library.error.errorcodes.ErrorCode;
import com.thanlinardos.spring_enterprise_library.model.entity.base.BasicIdJpa;
import com.thanlinardos.spring_enterprise_library.objects.utils.CollectionUtils;
import com.thanlinardos.spring_enterprise_library.time.api.DateTemporal;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;

public class PredicateUtils {
    public static <T, R> Predicate<T> filterBy(Predicate<R> pred, Function<T, R> extractor) {
        return t -> pred.test(extractor.apply(t));
    }

    public static <T, R, I> Predicate<T> filterBy(BiPredicate<R, I> pred, Function<T, R> extractor, I argument) {
        return t -> pred.test(extractor.apply(t), argument);
    }

    public static <T, R> Predicate<T> isEqualTo(@Nullable R compareTo, Function<T, R> extractor) {
        return t -> Objects.equals(compareTo, extractor.apply(t));
    }

    public static <T, R> Predicate<T> isNotEqualTo(@Nullable R compareTo, Function<T, R> extractor) {
        return t -> !Objects.equals(compareTo, extractor.apply(t));
    }

    @SafeVarargs
    public static <T, R> Predicate<T> isContainedIn(Function<T, R> extractor, R ... objects) {
        return t -> CollectionUtils.isIn(extractor.apply(t), objects);
    }

    public static <T, R> Predicate<T> isContainedIn(Function<T, R> extractor, Collection<R> objects) {
        return t -> CollectionUtils.isIn(extractor.apply(t), objects);
    }

    @SafeVarargs
    public static <T, R> Predicate<T> isNotContainedIn(Function<T, R> extractor, R ... objects) {
        return t -> CollectionUtils.isNotIn(extractor.apply(t), objects);
    }

    public static <T, R> Predicate<T> isNotContainedIn(Function<T, R> extractor, Collection<R> objects) {
        return t -> CollectionUtils.isNotIn(extractor.apply(t), objects);
    }

    public static <T, R> Predicate<T> contains(Collection<R> collection, Function<T, R> extractor) {
        return t -> collection.contains(extractor.apply(t));
    }

    public static <T, R> Predicate<T> notContains(Collection<R> collection, Function<T, R> extractor) {
        return PredicateUtils.negate(PredicateUtils.contains(collection, extractor));
    }

    public static <T> Predicate<T> negate(Predicate<T> pred) {
        return pred.negate();
    }

    public static <T, R> Predicate<T> nonNull(Function<T, R> extractor) {
        return t -> Objects.nonNull(extractor.apply(t));
    }

    public static <T, R> Predicate<T> isNull(Function<T, R> extractor) {
        return t -> Objects.isNull(extractor.apply(t));
    }

    public static <T> Predicate<T> throwIfNot(Predicate<T> predicate, ErrorCode errorCode, String message, String ... strings) {
        return value -> {
            if (!predicate.test(value)) {
                throw errorCode.createCoreException(message, strings);
            }
            return true;
        };
    }

    public static <T extends BasicIdJpa> Predicate<T> isEqualByIdTo(@Nonnull T compareTo) {
        return entity -> {
            if (compareTo.getId() == null) {
                return false;
            }
            return Objects.equals(compareTo.getId(), entity.getId());
        };
    }

    public static <T extends BasicIdJpa> Predicate<T> isNotEqualByIdTo(@Nonnull T compareTo) {
        return PredicateUtils.isEqualByIdTo(compareTo).negate();
    }

    public static <T, R> Predicate<T> isEqualToByKey(@Nullable T compareTo, Function<T, R> extractor) {
        return t -> Optional.ofNullable(compareTo).filter(PredicateUtils.isEqualTo(extractor.apply(t), extractor)).isPresent();
    }

    public static <T extends DateTemporal> Predicate<T> isInRange(LocalDate from, LocalDate to) {
        return temporal -> temporal.isInRange(from, to);
    }

    public static <T, R extends DateTemporal> Predicate<T> isInRange(Function<T, R> extractor, LocalDate from, LocalDate to) {
        return PredicateUtils.filterBy(PredicateUtils.isInRange(from, to), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> containsDate(LocalDate date) {
        return temporal -> temporal.containsDate(date);
    }

    public static <T, R extends DateTemporal> Predicate<T> containsDate(Function<T, R> extractor, LocalDate date) {
        return PredicateUtils.filterBy(PredicateUtils.containsDate(date), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> overlapsInterval(DateTemporal other) {
        return temporal -> temporal.overlapsInterval(other);
    }

    public static <T, R extends DateTemporal> Predicate<T> overlapsInterval(Function<T, R> extractor, DateTemporal other) {
        return PredicateUtils.filterBy(PredicateUtils.overlapsInterval(other), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> overlapsInterval(LocalDate from, LocalDate to) {
        return temporal -> temporal.overlapsInterval(from, to);
    }

    public static <T, R extends DateTemporal> Predicate<T> overlapsInterval(Function<T, R> extractor, LocalDate from, LocalDate to) {
        return PredicateUtils.filterBy(PredicateUtils.overlapsInterval(from, to), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> isContainedIn(LocalDate from, LocalDate to) {
        return temporal -> temporal.isContainedIn(from, to);
    }

    public static <T, R extends DateTemporal> Predicate<T> isContainedIn(Function<T, R> extractor, LocalDate from, LocalDate to) {
        return PredicateUtils.filterBy(PredicateUtils.isContainedIn(from, to), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> overlapsMonth(YearMonth yearMonth) {
        return temporal -> temporal.overlapsMonth(yearMonth);
    }

    public static <T, R extends DateTemporal> Predicate<T> overlapsMonth(Function<T, R> extractor, YearMonth yearMonth) {
        return PredicateUtils.filterBy(PredicateUtils.overlapsMonth(yearMonth), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> overlapsYear(Year year) {
        return temporal -> temporal.overlapsYear(year);
    }

    public static <T, R extends DateTemporal> Predicate<T> overlapsYear(Function<T, R> extractor, Year year) {
        return PredicateUtils.filterBy(PredicateUtils.overlapsYear(year), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> overlapsYear(LocalDate year) {
        return temporal -> temporal.overlapsYear(year);
    }

    public static <T, R extends DateTemporal> Predicate<T> overlapsYear(Function<T, R> extractor, LocalDate year) {
        return PredicateUtils.filterBy(PredicateUtils.overlapsYear(year), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> startsAfter(LocalDate date) {
        return temporal -> temporal.startsAfter(date);
    }

    public static <T, R extends DateTemporal> Predicate<T> startsAfter(Function<T, R> extractor, LocalDate date) {
        return PredicateUtils.filterBy(PredicateUtils.startsAfter(date), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> startsBefore(LocalDate date) {
        return temporal -> temporal.startsBefore(date);
    }

    public static <T, R extends DateTemporal> Predicate<T> startsBefore(Function<T, R> extractor, LocalDate date) {
        return PredicateUtils.filterBy(PredicateUtils.startsBefore(date), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> startsBeforeOrOn(LocalDate date) {
        return temporal -> temporal.startsBeforeOrOn(date);
    }

    public static <T, R extends DateTemporal> Predicate<T> startsBeforeOrOn(Function<T, R> extractor, LocalDate date) {
        return PredicateUtils.filterBy(PredicateUtils.startsBeforeOrOn(date), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> endsAfter(LocalDate date) {
        return temporal -> temporal.endsAfter(date);
    }

    public static <T, R extends DateTemporal> Predicate<T> endsAfter(Function<T, R> extractor, LocalDate date) {
        return PredicateUtils.filterBy(PredicateUtils.endsAfter(date), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> endsAfterOrOn(LocalDate date) {
        return temporal -> temporal.endsAfterOrOn(date);
    }

    public static <T, R extends DateTemporal> Predicate<T> endsAfterOrOn(Function<T, R> extractor, LocalDate date) {
        return PredicateUtils.filterBy(PredicateUtils.endsAfterOrOn(date), extractor);
    }

    public static <T extends DateTemporal> Predicate<T> overlap(DateTemporal other) {
        return temporal -> temporal.overlapsInterval(other);
    }

    public static <T, R extends DateTemporal> Predicate<T> overlap(Function<T, R> extractor, DateTemporal other) {
        return PredicateUtils.filterBy(PredicateUtils.overlap(other), extractor);
    }

    public static <T> Predicate<T> isTrue(Function<T, Boolean> extractor) {
        return t -> Boolean.TRUE.equals(extractor.apply(t));
    }

    public static <T> Predicate<T> isFalse(Function<T, Boolean> extractor) {
        return t -> Boolean.FALSE.equals(extractor.apply(t));
    }

    @Generated
    private PredicateUtils() {
    }
}

