/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.objects.utils;

import com.thanlinardos.spring_enterprise_library.error.errorcodes.ErrorCode;
import com.thanlinardos.spring_enterprise_library.objects.utils.CollectionUtils;
import com.thanlinardos.spring_enterprise_library.objects.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class StreamUtils {
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T> Predicate<T> duplicateByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) != null;
    }

    public static <T> Collector<T, ?, Optional<T>> findExactlyOneOrNone(String message, String ... strings) {
        return StreamUtils.findExactlyOneOrNone(ErrorCode.MORE_THAN_ONE_FOUND, message, () -> strings);
    }

    public static <T> Collector<T, ?, List<T>> removingDuplicates(Comparator<T> comparator) {
        return Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(comparator)), ArrayList::new);
    }

    public static <T> Collector<T, ?, Optional<T>> findExactlyOneOrNone(String message, Supplier<String[]> stringSupplier) {
        return StreamUtils.findExactlyOneOrNone(ErrorCode.MORE_THAN_ONE_FOUND, message, stringSupplier);
    }

    public static <T> Collector<T, ?, Optional<T>> findExactlyOneOrNone(ErrorCode errorCode, String message, String ... strings) {
        return StreamUtils.findExactlyOneOrNone(errorCode, message, () -> strings);
    }

    private static <T> Collector<T, ?, Optional<T>> findExactlyOneOrNone(ErrorCode errorCode, String message, Supplier<String[]> stringSupplier) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() > 1) {
                throw errorCode.createCoreException(message, (Object[])stringSupplier.get());
            }
            if (list.size() == 1) {
                return Optional.ofNullable(list.getFirst());
            }
            return Optional.empty();
        });
    }

    public static <T> Collector<T, ?, T> findExactlyOne(String message, String ... strings) {
        return StreamUtils.findExactlyOne(message, () -> strings);
    }

    public static <T> Collector<T, ?, T> findExactlyOne(String message, Supplier<String[]> stringSupplier) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() > 1) {
                throw ErrorCode.MORE_THAN_ONE_FOUND.createCoreException(message, (Object[])stringSupplier.get());
            }
            if (list.size() == 1) {
                return list.getFirst();
            }
            throw ErrorCode.NONE_FOUND.createCoreException(message, (Object[])stringSupplier.get());
        });
    }

    public static <T, R> Predicate<T> filterExactlyOneByKey(Function<? super T, R> keyExtractor, String errorMessage, String ... strings) {
        return StreamUtils.filterExactlyOneByKey(keyExtractor, (R key) -> errorMessage, strings);
    }

    public static <T, R> Predicate<T> filterExactlyOneByKey(Function<? super T, R> keyExtractor, Function<R, String> errorFactory, String ... strings) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> {
            Object key = keyExtractor.apply(t);
            if (seen.containsKey(key)) {
                throw ErrorCode.MORE_THAN_ONE_FOUND.createCoreException((String)errorFactory.apply(key), strings);
            }
            return seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
        };
    }

    public static <T> Collector<T, ?, Optional<T>> findExactlyOneOtherwiseNone() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() == 1) {
                return Optional.of(list.getFirst());
            }
            return Optional.empty();
        });
    }

    public static <T> Collector<T, ?, Boolean> isEmpty() {
        return Collectors.collectingAndThen(Collectors.toList(), CollectionUtils::isEmpty);
    }

    public static <T> Collector<T, ?, Boolean> isNotEmpty() {
        return Collectors.collectingAndThen(Collectors.toList(), CollectionUtils::isNotEmpty);
    }

    public static <T> Stream<T> ofNullable(Collection<T> collection) {
        return Stream.ofNullable(collection).flatMap(Collection::stream);
    }

    public static <T> Stream<T> ofNullable(T[] collection) {
        return Stream.ofNullable(collection).flatMap(Arrays::stream);
    }

    public static <T, R> Stream<R> ofNullable(T object, Function<T, Collection<R>> extractor) {
        return Stream.ofNullable(object).map(extractor).flatMap(Collection::stream);
    }

    public static <T, R> Stream<R> of(T object, Function<T, Collection<R>> extractor) {
        return Stream.of(object).map(extractor).flatMap(Collection::stream);
    }

    @SafeVarargs
    public static <T> Supplier<String[]> getDebugStringSuppliers(T ... items) {
        return () -> (String[])Arrays.stream(items).map(ObjectUtils::getDebugString).toArray(String[]::new);
    }

    @Generated
    private StreamUtils() {
    }
}

