/*
 * Decompiled with CFR 0.152.
 */
package com.thanlinardos.spring_enterprise_library.time;

import com.thanlinardos.spring_enterprise_library.time.api.TimeProvider;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy(value=false)
@Component
public class TimeFactory {
    private static TimeProvider timeProvider;

    public TimeFactory(TimeProvider timeProvider) {
        TimeFactory.timeProvider = timeProvider;
    }

    public static TimeUnit getAccuracy() {
        return timeProvider.accuracy();
    }

    public static LocalDate getDate() {
        return timeProvider.getCurrentDate();
    }

    public static LocalDateTime getDateTime() {
        return timeProvider.getCurrentDateTime();
    }

    public static Instant getInstant() {
        return timeProvider.getCurrentInstant();
    }

    public static LocalDate getMaxDate() {
        return timeProvider.maxDate();
    }

    public static LocalDate getMinDate() {
        return timeProvider.minDate();
    }

    public static LocalDateTime getMaxDateTime() {
        return timeProvider.maxDateTime();
    }

    public static LocalDateTime getMinDateTime() {
        return timeProvider.minDateTime();
    }

    public static Instant getMaxInstant() {
        return TimeFactory.getMaxDateTime().toInstant(TimeFactory.getDefaultZone());
    }

    public static Instant getMinInstant() {
        return TimeFactory.getMinDateTime().toInstant(TimeFactory.getDefaultZone());
    }

    public static ZoneId getDefaultZoneId() {
        return timeProvider.zoneId();
    }

    public static ZoneOffset getDefaultZone() {
        return timeProvider.getDefaultZone();
    }
}

